/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongCharMap}s.
 *
 * @see LongCharMap
 */
public interface LongCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see LongCharMap#defaultValue()
     */
    LongCharMapFactory withDefaultValue(char defaultValue);

     LongCharMap newMutableMap();

     LongCharMap newMutableMap(int expectedSize);

    


     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
     LongCharMap newMutableMap(Map<Long, Character> map);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

     LongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


     LongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

     LongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

     LongCharMap newMutableMap(long[] keys, char[] values);

     LongCharMap newMutableMap(long[] keys, char[] values,
            int expectedSize);

     LongCharMap newMutableMap(Long[] keys, Character[] values);

     LongCharMap newMutableMap(Long[] keys, Character[] values,
            int expectedSize);

     LongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values);

     LongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


     LongCharMap newMutableMapOf(long k1, char v1);

     LongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2);

     LongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

     LongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

     LongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
     LongCharMap newUpdatableMap();

     LongCharMap newUpdatableMap(int expectedSize);

    


     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
     LongCharMap newUpdatableMap(Map<Long, Character> map);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

     LongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


     LongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

     LongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

     LongCharMap newUpdatableMap(long[] keys, char[] values);

     LongCharMap newUpdatableMap(long[] keys, char[] values,
            int expectedSize);

     LongCharMap newUpdatableMap(Long[] keys, Character[] values);

     LongCharMap newUpdatableMap(Long[] keys, Character[] values,
            int expectedSize);

     LongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values);

     LongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


     LongCharMap newUpdatableMapOf(long k1, char v1);

     LongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2);

     LongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

     LongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

     LongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);

    


     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
     LongCharMap newImmutableMap(Map<Long, Character> map);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

     LongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


     LongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

     LongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

     LongCharMap newImmutableMap(long[] keys, char[] values);

     LongCharMap newImmutableMap(long[] keys, char[] values,
            int expectedSize);

     LongCharMap newImmutableMap(Long[] keys, Character[] values);

     LongCharMap newImmutableMap(Long[] keys, Character[] values,
            int expectedSize);

     LongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values);

     LongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


     LongCharMap newImmutableMapOf(long k1, char v1);

     LongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2);

     LongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

     LongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

     LongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
}

