/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongByteMap}s.
 *
 * @see LongByteMap
 */
public interface LongByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see LongByteMap#defaultValue()
     */
    LongByteMapFactory withDefaultValue(byte defaultValue);

     LongByteMap newMutableMap();

     LongByteMap newMutableMap(int expectedSize);

    


     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
     LongByteMap newMutableMap(Map<Long, Byte> map);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

     LongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


     LongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

     LongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

     LongByteMap newMutableMap(long[] keys, byte[] values);

     LongByteMap newMutableMap(long[] keys, byte[] values,
            int expectedSize);

     LongByteMap newMutableMap(Long[] keys, Byte[] values);

     LongByteMap newMutableMap(Long[] keys, Byte[] values,
            int expectedSize);

     LongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values);

     LongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


     LongByteMap newMutableMapOf(long k1, byte v1);

     LongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2);

     LongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

     LongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

     LongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
     LongByteMap newUpdatableMap();

     LongByteMap newUpdatableMap(int expectedSize);

    


     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
     LongByteMap newUpdatableMap(Map<Long, Byte> map);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

     LongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


     LongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

     LongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

     LongByteMap newUpdatableMap(long[] keys, byte[] values);

     LongByteMap newUpdatableMap(long[] keys, byte[] values,
            int expectedSize);

     LongByteMap newUpdatableMap(Long[] keys, Byte[] values);

     LongByteMap newUpdatableMap(Long[] keys, Byte[] values,
            int expectedSize);

     LongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values);

     LongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


     LongByteMap newUpdatableMapOf(long k1, byte v1);

     LongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2);

     LongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

     LongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

     LongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);

    


     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
     LongByteMap newImmutableMap(Map<Long, Byte> map);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

     LongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


     LongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

     LongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

     LongByteMap newImmutableMap(long[] keys, byte[] values);

     LongByteMap newImmutableMap(long[] keys, byte[] values,
            int expectedSize);

     LongByteMap newImmutableMap(Long[] keys, Byte[] values);

     LongByteMap newImmutableMap(Long[] keys, Byte[] values,
            int expectedSize);

     LongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values);

     LongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


     LongByteMap newImmutableMapOf(long k1, byte v1);

     LongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2);

     LongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

     LongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

     LongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
}

