/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntShortMap}s.
 *
 * @see IntShortMap
 */
public interface IntShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see IntShortMap#defaultValue()
     */
    IntShortMapFactory withDefaultValue(short defaultValue);

     IntShortMap newMutableMap();

     IntShortMap newMutableMap(int expectedSize);

    


     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
     IntShortMap newMutableMap(Map<Integer, Short> map);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

     IntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


     IntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

     IntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

     IntShortMap newMutableMap(int[] keys, short[] values);

     IntShortMap newMutableMap(int[] keys, short[] values,
            int expectedSize);

     IntShortMap newMutableMap(Integer[] keys, Short[] values);

     IntShortMap newMutableMap(Integer[] keys, Short[] values,
            int expectedSize);

     IntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values);

     IntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


     IntShortMap newMutableMapOf(int k1, short v1);

     IntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2);

     IntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

     IntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

     IntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
     IntShortMap newUpdatableMap();

     IntShortMap newUpdatableMap(int expectedSize);

    


     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
     IntShortMap newUpdatableMap(Map<Integer, Short> map);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

     IntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


     IntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

     IntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

     IntShortMap newUpdatableMap(int[] keys, short[] values);

     IntShortMap newUpdatableMap(int[] keys, short[] values,
            int expectedSize);

     IntShortMap newUpdatableMap(Integer[] keys, Short[] values);

     IntShortMap newUpdatableMap(Integer[] keys, Short[] values,
            int expectedSize);

     IntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values);

     IntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


     IntShortMap newUpdatableMapOf(int k1, short v1);

     IntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2);

     IntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

     IntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

     IntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);

    


     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
     IntShortMap newImmutableMap(Map<Integer, Short> map);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

     IntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


     IntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

     IntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

     IntShortMap newImmutableMap(int[] keys, short[] values);

     IntShortMap newImmutableMap(int[] keys, short[] values,
            int expectedSize);

     IntShortMap newImmutableMap(Integer[] keys, Short[] values);

     IntShortMap newImmutableMap(Integer[] keys, Short[] values,
            int expectedSize);

     IntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values);

     IntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


     IntShortMap newImmutableMapOf(int k1, short v1);

     IntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2);

     IntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

     IntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

     IntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
}

