/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntLongMap}s.
 *
 * @see IntLongMap
 */
public interface IntLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see IntLongMap#defaultValue()
     */
    IntLongMapFactory withDefaultValue(long defaultValue);

     IntLongMap newMutableMap();

     IntLongMap newMutableMap(int expectedSize);

    


     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
     IntLongMap newMutableMap(Map<Integer, Long> map);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

     IntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


     IntLongMap newMutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

     IntLongMap newMutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

     IntLongMap newMutableMap(int[] keys, long[] values);

     IntLongMap newMutableMap(int[] keys, long[] values,
            int expectedSize);

     IntLongMap newMutableMap(Integer[] keys, Long[] values);

     IntLongMap newMutableMap(Integer[] keys, Long[] values,
            int expectedSize);

     IntLongMap newMutableMap(Iterable<Integer> keys,
            Iterable<Long> values);

     IntLongMap newMutableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


     IntLongMap newMutableMapOf(int k1, long v1);

     IntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2);

     IntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

     IntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

     IntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
     IntLongMap newUpdatableMap();

     IntLongMap newUpdatableMap(int expectedSize);

    


     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
     IntLongMap newUpdatableMap(Map<Integer, Long> map);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

     IntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


     IntLongMap newUpdatableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

     IntLongMap newUpdatableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

     IntLongMap newUpdatableMap(int[] keys, long[] values);

     IntLongMap newUpdatableMap(int[] keys, long[] values,
            int expectedSize);

     IntLongMap newUpdatableMap(Integer[] keys, Long[] values);

     IntLongMap newUpdatableMap(Integer[] keys, Long[] values,
            int expectedSize);

     IntLongMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Long> values);

     IntLongMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


     IntLongMap newUpdatableMapOf(int k1, long v1);

     IntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2);

     IntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

     IntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

     IntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);

    


     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
     IntLongMap newImmutableMap(Map<Integer, Long> map);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

     IntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


     IntLongMap newImmutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

     IntLongMap newImmutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

     IntLongMap newImmutableMap(int[] keys, long[] values);

     IntLongMap newImmutableMap(int[] keys, long[] values,
            int expectedSize);

     IntLongMap newImmutableMap(Integer[] keys, Long[] values);

     IntLongMap newImmutableMap(Integer[] keys, Long[] values,
            int expectedSize);

     IntLongMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Long> values);

     IntLongMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


     IntLongMap newImmutableMapOf(int k1, long v1);

     IntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2);

     IntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

     IntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

     IntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
}

