/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntIntMap}s.
 *
 * @see IntIntMap
 */
public interface IntIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see IntIntMap#defaultValue()
     */
    IntIntMapFactory withDefaultValue(int defaultValue);

     IntIntMap newMutableMap();

     IntIntMap newMutableMap(int expectedSize);

    


     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
     IntIntMap newMutableMap(Map<Integer, Integer> map);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

     IntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


     IntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

     IntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

     IntIntMap newMutableMap(int[] keys, int[] values);

     IntIntMap newMutableMap(int[] keys, int[] values,
            int expectedSize);

     IntIntMap newMutableMap(Integer[] keys, Integer[] values);

     IntIntMap newMutableMap(Integer[] keys, Integer[] values,
            int expectedSize);

     IntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

     IntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


     IntIntMap newMutableMapOf(int k1, int v1);

     IntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2);

     IntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

     IntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

     IntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
     IntIntMap newUpdatableMap();

     IntIntMap newUpdatableMap(int expectedSize);

    


     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
     IntIntMap newUpdatableMap(Map<Integer, Integer> map);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

     IntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


     IntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

     IntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

     IntIntMap newUpdatableMap(int[] keys, int[] values);

     IntIntMap newUpdatableMap(int[] keys, int[] values,
            int expectedSize);

     IntIntMap newUpdatableMap(Integer[] keys, Integer[] values);

     IntIntMap newUpdatableMap(Integer[] keys, Integer[] values,
            int expectedSize);

     IntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

     IntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


     IntIntMap newUpdatableMapOf(int k1, int v1);

     IntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2);

     IntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

     IntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

     IntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);

    


     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
     IntIntMap newImmutableMap(Map<Integer, Integer> map);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

     IntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


     IntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

     IntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

     IntIntMap newImmutableMap(int[] keys, int[] values);

     IntIntMap newImmutableMap(int[] keys, int[] values,
            int expectedSize);

     IntIntMap newImmutableMap(Integer[] keys, Integer[] values);

     IntIntMap newImmutableMap(Integer[] keys, Integer[] values,
            int expectedSize);

     IntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

     IntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


     IntIntMap newImmutableMapOf(int k1, int v1);

     IntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2);

     IntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

     IntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

     IntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
}

