/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntFloatMap}s.
 *
 * @see IntFloatMap
 */
public interface IntFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see IntFloatMap#defaultValue()
     */
    IntFloatMapFactory withDefaultValue(float defaultValue);

     IntFloatMap newMutableMap();

     IntFloatMap newMutableMap(int expectedSize);

    


     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
     IntFloatMap newMutableMap(Map<Integer, Float> map);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

     IntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


     IntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

     IntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

     IntFloatMap newMutableMap(int[] keys, float[] values);

     IntFloatMap newMutableMap(int[] keys, float[] values,
            int expectedSize);

     IntFloatMap newMutableMap(Integer[] keys, Float[] values);

     IntFloatMap newMutableMap(Integer[] keys, Float[] values,
            int expectedSize);

     IntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values);

     IntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


     IntFloatMap newMutableMapOf(int k1, float v1);

     IntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2);

     IntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

     IntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

     IntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);
     IntFloatMap newUpdatableMap();

     IntFloatMap newUpdatableMap(int expectedSize);

    


     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
     IntFloatMap newUpdatableMap(Map<Integer, Float> map);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

     IntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


     IntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

     IntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

     IntFloatMap newUpdatableMap(int[] keys, float[] values);

     IntFloatMap newUpdatableMap(int[] keys, float[] values,
            int expectedSize);

     IntFloatMap newUpdatableMap(Integer[] keys, Float[] values);

     IntFloatMap newUpdatableMap(Integer[] keys, Float[] values,
            int expectedSize);

     IntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values);

     IntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


     IntFloatMap newUpdatableMapOf(int k1, float v1);

     IntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2);

     IntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

     IntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

     IntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);

    


     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
     IntFloatMap newImmutableMap(Map<Integer, Float> map);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

     IntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


     IntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

     IntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

     IntFloatMap newImmutableMap(int[] keys, float[] values);

     IntFloatMap newImmutableMap(int[] keys, float[] values,
            int expectedSize);

     IntFloatMap newImmutableMap(Integer[] keys, Float[] values);

     IntFloatMap newImmutableMap(Integer[] keys, Float[] values,
            int expectedSize);

     IntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values);

     IntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


     IntFloatMap newImmutableMapOf(int k1, float v1);

     IntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2);

     IntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

     IntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

     IntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);
}

