/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntDoubleMap}s.
 *
 * @see IntDoubleMap
 */
public interface IntDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see IntDoubleMap#defaultValue()
     */
    IntDoubleMapFactory withDefaultValue(double defaultValue);

     IntDoubleMap newMutableMap();

     IntDoubleMap newMutableMap(int expectedSize);

    


     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
     IntDoubleMap newMutableMap(Map<Integer, Double> map);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

     IntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


     IntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

     IntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

     IntDoubleMap newMutableMap(int[] keys, double[] values);

     IntDoubleMap newMutableMap(int[] keys, double[] values,
            int expectedSize);

     IntDoubleMap newMutableMap(Integer[] keys, Double[] values);

     IntDoubleMap newMutableMap(Integer[] keys, Double[] values,
            int expectedSize);

     IntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values);

     IntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


     IntDoubleMap newMutableMapOf(int k1, double v1);

     IntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2);

     IntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

     IntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

     IntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
     IntDoubleMap newUpdatableMap();

     IntDoubleMap newUpdatableMap(int expectedSize);

    


     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
     IntDoubleMap newUpdatableMap(Map<Integer, Double> map);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

     IntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


     IntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

     IntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

     IntDoubleMap newUpdatableMap(int[] keys, double[] values);

     IntDoubleMap newUpdatableMap(int[] keys, double[] values,
            int expectedSize);

     IntDoubleMap newUpdatableMap(Integer[] keys, Double[] values);

     IntDoubleMap newUpdatableMap(Integer[] keys, Double[] values,
            int expectedSize);

     IntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values);

     IntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


     IntDoubleMap newUpdatableMapOf(int k1, double v1);

     IntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2);

     IntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

     IntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

     IntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);

    


     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
     IntDoubleMap newImmutableMap(Map<Integer, Double> map);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

     IntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


     IntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

     IntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

     IntDoubleMap newImmutableMap(int[] keys, double[] values);

     IntDoubleMap newImmutableMap(int[] keys, double[] values,
            int expectedSize);

     IntDoubleMap newImmutableMap(Integer[] keys, Double[] values);

     IntDoubleMap newImmutableMap(Integer[] keys, Double[] values,
            int expectedSize);

     IntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values);

     IntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


     IntDoubleMap newImmutableMapOf(int k1, double v1);

     IntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2);

     IntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

     IntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

     IntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
}

