/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntCharMap}s.
 *
 * @see IntCharMap
 */
public interface IntCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see IntCharMap#defaultValue()
     */
    IntCharMapFactory withDefaultValue(char defaultValue);

     IntCharMap newMutableMap();

     IntCharMap newMutableMap(int expectedSize);

    


     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
     IntCharMap newMutableMap(Map<Integer, Character> map);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

     IntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


     IntCharMap newMutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

     IntCharMap newMutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

     IntCharMap newMutableMap(int[] keys, char[] values);

     IntCharMap newMutableMap(int[] keys, char[] values,
            int expectedSize);

     IntCharMap newMutableMap(Integer[] keys, Character[] values);

     IntCharMap newMutableMap(Integer[] keys, Character[] values,
            int expectedSize);

     IntCharMap newMutableMap(Iterable<Integer> keys,
            Iterable<Character> values);

     IntCharMap newMutableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


     IntCharMap newMutableMapOf(int k1, char v1);

     IntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2);

     IntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

     IntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

     IntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
     IntCharMap newUpdatableMap();

     IntCharMap newUpdatableMap(int expectedSize);

    


     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
     IntCharMap newUpdatableMap(Map<Integer, Character> map);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

     IntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


     IntCharMap newUpdatableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

     IntCharMap newUpdatableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

     IntCharMap newUpdatableMap(int[] keys, char[] values);

     IntCharMap newUpdatableMap(int[] keys, char[] values,
            int expectedSize);

     IntCharMap newUpdatableMap(Integer[] keys, Character[] values);

     IntCharMap newUpdatableMap(Integer[] keys, Character[] values,
            int expectedSize);

     IntCharMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Character> values);

     IntCharMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


     IntCharMap newUpdatableMapOf(int k1, char v1);

     IntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2);

     IntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

     IntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

     IntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);

    


     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
     IntCharMap newImmutableMap(Map<Integer, Character> map);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

     IntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


     IntCharMap newImmutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

     IntCharMap newImmutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

     IntCharMap newImmutableMap(int[] keys, char[] values);

     IntCharMap newImmutableMap(int[] keys, char[] values,
            int expectedSize);

     IntCharMap newImmutableMap(Integer[] keys, Character[] values);

     IntCharMap newImmutableMap(Integer[] keys, Character[] values,
            int expectedSize);

     IntCharMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Character> values);

     IntCharMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


     IntCharMap newImmutableMapOf(int k1, char v1);

     IntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2);

     IntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

     IntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

     IntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
}

