/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.IntByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code IntByteMap}s.
 *
 * @see IntByteMap
 */
public interface IntByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see IntByteMap#defaultValue()
     */
    IntByteMapFactory withDefaultValue(byte defaultValue);

     IntByteMap newMutableMap();

     IntByteMap newMutableMap(int expectedSize);

    


     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
     IntByteMap newMutableMap(Map<Integer, Byte> map);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

     IntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


     IntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

     IntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

     IntByteMap newMutableMap(int[] keys, byte[] values);

     IntByteMap newMutableMap(int[] keys, byte[] values,
            int expectedSize);

     IntByteMap newMutableMap(Integer[] keys, Byte[] values);

     IntByteMap newMutableMap(Integer[] keys, Byte[] values,
            int expectedSize);

     IntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

     IntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


     IntByteMap newMutableMapOf(int k1, byte v1);

     IntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2);

     IntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

     IntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

     IntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
     IntByteMap newUpdatableMap();

     IntByteMap newUpdatableMap(int expectedSize);

    


     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
     IntByteMap newUpdatableMap(Map<Integer, Byte> map);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

     IntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


     IntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

     IntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

     IntByteMap newUpdatableMap(int[] keys, byte[] values);

     IntByteMap newUpdatableMap(int[] keys, byte[] values,
            int expectedSize);

     IntByteMap newUpdatableMap(Integer[] keys, Byte[] values);

     IntByteMap newUpdatableMap(Integer[] keys, Byte[] values,
            int expectedSize);

     IntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

     IntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


     IntByteMap newUpdatableMapOf(int k1, byte v1);

     IntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2);

     IntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

     IntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

     IntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);

    


     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
     IntByteMap newImmutableMap(Map<Integer, Byte> map);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

     IntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


     IntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

     IntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

     IntByteMap newImmutableMap(int[] keys, byte[] values);

     IntByteMap newImmutableMap(int[] keys, byte[] values,
            int expectedSize);

     IntByteMap newImmutableMap(Integer[] keys, Byte[] values);

     IntByteMap newImmutableMap(Integer[] keys, Byte[] values,
            int expectedSize);

     IntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

     IntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


     IntByteMap newImmutableMapOf(int k1, byte v1);

     IntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2);

     IntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

     IntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

     IntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
}

