/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatShortMap}s.
 *
 * @see FloatShortMap
 */
public interface FloatShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see FloatShortMap#defaultValue()
     */
    FloatShortMapFactory withDefaultValue(short defaultValue);

     FloatShortMap newMutableMap();

     FloatShortMap newMutableMap(int expectedSize);

    


     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
     FloatShortMap newMutableMap(Map<Float, Short> map);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

     FloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


     FloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

     FloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

     FloatShortMap newMutableMap(float[] keys, short[] values);

     FloatShortMap newMutableMap(float[] keys, short[] values,
            int expectedSize);

     FloatShortMap newMutableMap(Float[] keys, Short[] values);

     FloatShortMap newMutableMap(Float[] keys, Short[] values,
            int expectedSize);

     FloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values);

     FloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


     FloatShortMap newMutableMapOf(float k1, short v1);

     FloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2);

     FloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

     FloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

     FloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
     FloatShortMap newUpdatableMap();

     FloatShortMap newUpdatableMap(int expectedSize);

    


     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
     FloatShortMap newUpdatableMap(Map<Float, Short> map);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

     FloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


     FloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

     FloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

     FloatShortMap newUpdatableMap(float[] keys, short[] values);

     FloatShortMap newUpdatableMap(float[] keys, short[] values,
            int expectedSize);

     FloatShortMap newUpdatableMap(Float[] keys, Short[] values);

     FloatShortMap newUpdatableMap(Float[] keys, Short[] values,
            int expectedSize);

     FloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values);

     FloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


     FloatShortMap newUpdatableMapOf(float k1, short v1);

     FloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2);

     FloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

     FloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

     FloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);

    


     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
     FloatShortMap newImmutableMap(Map<Float, Short> map);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

     FloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


     FloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

     FloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

     FloatShortMap newImmutableMap(float[] keys, short[] values);

     FloatShortMap newImmutableMap(float[] keys, short[] values,
            int expectedSize);

     FloatShortMap newImmutableMap(Float[] keys, Short[] values);

     FloatShortMap newImmutableMap(Float[] keys, Short[] values,
            int expectedSize);

     FloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values);

     FloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


     FloatShortMap newImmutableMapOf(float k1, short v1);

     FloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2);

     FloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

     FloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

     FloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
}

