/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatObjConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatObjMap}s.
 *
 * @see FloatObjMap
 */
public interface FloatObjMapFactory<V> {

    

    

    

    

    

    
    

    
    



    @Nullable Equivalence<V> getValueEquivalence();

    <VE> FloatObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    <V2 extends V> FloatObjMap<V2> newMutableMap();

    <V2 extends V> FloatObjMap<V2> newMutableMap(int expectedSize);

    


    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5);


    <V2 extends V> FloatObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier);

    <V2 extends V> FloatObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newMutableMap(float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values);

    <V2 extends V> FloatObjMap<V2> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> FloatObjMap<V2> newMutableMapOf(float k1, V2 v1);

    <V2 extends V> FloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    <V2 extends V> FloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    <V2 extends V> FloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    <V2 extends V> FloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);
    <V2 extends V> FloatObjMap<V2> newUpdatableMap();

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(int expectedSize);

    


    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5);


    <V2 extends V> FloatObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V2> values);

    <V2 extends V> FloatObjMap<V2> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> FloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1);

    <V2 extends V> FloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    <V2 extends V> FloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    <V2 extends V> FloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    <V2 extends V> FloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);

    


    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Map<Float, ? extends V2> map1,
            Map<Float, ? extends V2> map2, Map<Float, ? extends V2> map3,
            Map<Float, ? extends V2> map4, Map<Float, ? extends V2> map5);


    <V2 extends V> FloatObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Float[] keys, V2[] values);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Float[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values);

    <V2 extends V> FloatObjMap<V2> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> FloatObjMap<V2> newImmutableMapOf(float k1, V2 v1);

    <V2 extends V> FloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    <V2 extends V> FloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    <V2 extends V> FloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    <V2 extends V> FloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);
}

