/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatLongMap}s.
 *
 * @see FloatLongMap
 */
public interface FloatLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see FloatLongMap#defaultValue()
     */
    FloatLongMapFactory withDefaultValue(long defaultValue);

     FloatLongMap newMutableMap();

     FloatLongMap newMutableMap(int expectedSize);

    


     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
     FloatLongMap newMutableMap(Map<Float, Long> map);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

     FloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


     FloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

     FloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

     FloatLongMap newMutableMap(float[] keys, long[] values);

     FloatLongMap newMutableMap(float[] keys, long[] values,
            int expectedSize);

     FloatLongMap newMutableMap(Float[] keys, Long[] values);

     FloatLongMap newMutableMap(Float[] keys, Long[] values,
            int expectedSize);

     FloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values);

     FloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


     FloatLongMap newMutableMapOf(float k1, long v1);

     FloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2);

     FloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

     FloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

     FloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
     FloatLongMap newUpdatableMap();

     FloatLongMap newUpdatableMap(int expectedSize);

    


     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
     FloatLongMap newUpdatableMap(Map<Float, Long> map);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

     FloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


     FloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

     FloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

     FloatLongMap newUpdatableMap(float[] keys, long[] values);

     FloatLongMap newUpdatableMap(float[] keys, long[] values,
            int expectedSize);

     FloatLongMap newUpdatableMap(Float[] keys, Long[] values);

     FloatLongMap newUpdatableMap(Float[] keys, Long[] values,
            int expectedSize);

     FloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values);

     FloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


     FloatLongMap newUpdatableMapOf(float k1, long v1);

     FloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2);

     FloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

     FloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

     FloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);

    


     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
     FloatLongMap newImmutableMap(Map<Float, Long> map);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

     FloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


     FloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

     FloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

     FloatLongMap newImmutableMap(float[] keys, long[] values);

     FloatLongMap newImmutableMap(float[] keys, long[] values,
            int expectedSize);

     FloatLongMap newImmutableMap(Float[] keys, Long[] values);

     FloatLongMap newImmutableMap(Float[] keys, Long[] values,
            int expectedSize);

     FloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values);

     FloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


     FloatLongMap newImmutableMapOf(float k1, long v1);

     FloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2);

     FloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

     FloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

     FloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
}

