/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatIntMap}s.
 *
 * @see FloatIntMap
 */
public interface FloatIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see FloatIntMap#defaultValue()
     */
    FloatIntMapFactory withDefaultValue(int defaultValue);

     FloatIntMap newMutableMap();

     FloatIntMap newMutableMap(int expectedSize);

    


     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
     FloatIntMap newMutableMap(Map<Float, Integer> map);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

     FloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


     FloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

     FloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

     FloatIntMap newMutableMap(float[] keys, int[] values);

     FloatIntMap newMutableMap(float[] keys, int[] values,
            int expectedSize);

     FloatIntMap newMutableMap(Float[] keys, Integer[] values);

     FloatIntMap newMutableMap(Float[] keys, Integer[] values,
            int expectedSize);

     FloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values);

     FloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


     FloatIntMap newMutableMapOf(float k1, int v1);

     FloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2);

     FloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

     FloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

     FloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
     FloatIntMap newUpdatableMap();

     FloatIntMap newUpdatableMap(int expectedSize);

    


     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
     FloatIntMap newUpdatableMap(Map<Float, Integer> map);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

     FloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


     FloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

     FloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

     FloatIntMap newUpdatableMap(float[] keys, int[] values);

     FloatIntMap newUpdatableMap(float[] keys, int[] values,
            int expectedSize);

     FloatIntMap newUpdatableMap(Float[] keys, Integer[] values);

     FloatIntMap newUpdatableMap(Float[] keys, Integer[] values,
            int expectedSize);

     FloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values);

     FloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


     FloatIntMap newUpdatableMapOf(float k1, int v1);

     FloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2);

     FloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

     FloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

     FloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);

    


     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
     FloatIntMap newImmutableMap(Map<Float, Integer> map);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

     FloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


     FloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

     FloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

     FloatIntMap newImmutableMap(float[] keys, int[] values);

     FloatIntMap newImmutableMap(float[] keys, int[] values,
            int expectedSize);

     FloatIntMap newImmutableMap(Float[] keys, Integer[] values);

     FloatIntMap newImmutableMap(Float[] keys, Integer[] values,
            int expectedSize);

     FloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values);

     FloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


     FloatIntMap newImmutableMapOf(float k1, int v1);

     FloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2);

     FloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

     FloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

     FloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
}

