/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatFloatMap}s.
 *
 * @see FloatFloatMap
 */
public interface FloatFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see FloatFloatMap#defaultValue()
     */
    FloatFloatMapFactory withDefaultValue(float defaultValue);

     FloatFloatMap newMutableMap();

     FloatFloatMap newMutableMap(int expectedSize);

    


     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
     FloatFloatMap newMutableMap(Map<Float, Float> map);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

     FloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


     FloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

     FloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

     FloatFloatMap newMutableMap(float[] keys, float[] values);

     FloatFloatMap newMutableMap(float[] keys, float[] values,
            int expectedSize);

     FloatFloatMap newMutableMap(Float[] keys, Float[] values);

     FloatFloatMap newMutableMap(Float[] keys, Float[] values,
            int expectedSize);

     FloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values);

     FloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


     FloatFloatMap newMutableMapOf(float k1, float v1);

     FloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2);

     FloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

     FloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

     FloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
     FloatFloatMap newUpdatableMap();

     FloatFloatMap newUpdatableMap(int expectedSize);

    


     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
     FloatFloatMap newUpdatableMap(Map<Float, Float> map);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

     FloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


     FloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

     FloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

     FloatFloatMap newUpdatableMap(float[] keys, float[] values);

     FloatFloatMap newUpdatableMap(float[] keys, float[] values,
            int expectedSize);

     FloatFloatMap newUpdatableMap(Float[] keys, Float[] values);

     FloatFloatMap newUpdatableMap(Float[] keys, Float[] values,
            int expectedSize);

     FloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values);

     FloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


     FloatFloatMap newUpdatableMapOf(float k1, float v1);

     FloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2);

     FloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

     FloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

     FloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);

    


     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
     FloatFloatMap newImmutableMap(Map<Float, Float> map);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

     FloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


     FloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

     FloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

     FloatFloatMap newImmutableMap(float[] keys, float[] values);

     FloatFloatMap newImmutableMap(float[] keys, float[] values,
            int expectedSize);

     FloatFloatMap newImmutableMap(Float[] keys, Float[] values);

     FloatFloatMap newImmutableMap(Float[] keys, Float[] values,
            int expectedSize);

     FloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values);

     FloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


     FloatFloatMap newImmutableMapOf(float k1, float v1);

     FloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2);

     FloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

     FloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

     FloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
}

