/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatDoubleMap}s.
 *
 * @see FloatDoubleMap
 */
public interface FloatDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see FloatDoubleMap#defaultValue()
     */
    FloatDoubleMapFactory withDefaultValue(double defaultValue);

     FloatDoubleMap newMutableMap();

     FloatDoubleMap newMutableMap(int expectedSize);

    


     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
     FloatDoubleMap newMutableMap(Map<Float, Double> map);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

     FloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


     FloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

     FloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

     FloatDoubleMap newMutableMap(float[] keys, double[] values);

     FloatDoubleMap newMutableMap(float[] keys, double[] values,
            int expectedSize);

     FloatDoubleMap newMutableMap(Float[] keys, Double[] values);

     FloatDoubleMap newMutableMap(Float[] keys, Double[] values,
            int expectedSize);

     FloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values);

     FloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


     FloatDoubleMap newMutableMapOf(float k1, double v1);

     FloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2);

     FloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

     FloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

     FloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
     FloatDoubleMap newUpdatableMap();

     FloatDoubleMap newUpdatableMap(int expectedSize);

    


     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
     FloatDoubleMap newUpdatableMap(Map<Float, Double> map);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

     FloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


     FloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

     FloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

     FloatDoubleMap newUpdatableMap(float[] keys, double[] values);

     FloatDoubleMap newUpdatableMap(float[] keys, double[] values,
            int expectedSize);

     FloatDoubleMap newUpdatableMap(Float[] keys, Double[] values);

     FloatDoubleMap newUpdatableMap(Float[] keys, Double[] values,
            int expectedSize);

     FloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values);

     FloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


     FloatDoubleMap newUpdatableMapOf(float k1, double v1);

     FloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2);

     FloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

     FloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

     FloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);

    


     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
     FloatDoubleMap newImmutableMap(Map<Float, Double> map);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

     FloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


     FloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

     FloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

     FloatDoubleMap newImmutableMap(float[] keys, double[] values);

     FloatDoubleMap newImmutableMap(float[] keys, double[] values,
            int expectedSize);

     FloatDoubleMap newImmutableMap(Float[] keys, Double[] values);

     FloatDoubleMap newImmutableMap(Float[] keys, Double[] values,
            int expectedSize);

     FloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values);

     FloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


     FloatDoubleMap newImmutableMapOf(float k1, double v1);

     FloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2);

     FloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

     FloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

     FloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
}

