/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatCharMap}s.
 *
 * @see FloatCharMap
 */
public interface FloatCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see FloatCharMap#defaultValue()
     */
    FloatCharMapFactory withDefaultValue(char defaultValue);

     FloatCharMap newMutableMap();

     FloatCharMap newMutableMap(int expectedSize);

    


     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
     FloatCharMap newMutableMap(Map<Float, Character> map);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

     FloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


     FloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

     FloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

     FloatCharMap newMutableMap(float[] keys, char[] values);

     FloatCharMap newMutableMap(float[] keys, char[] values,
            int expectedSize);

     FloatCharMap newMutableMap(Float[] keys, Character[] values);

     FloatCharMap newMutableMap(Float[] keys, Character[] values,
            int expectedSize);

     FloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values);

     FloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


     FloatCharMap newMutableMapOf(float k1, char v1);

     FloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2);

     FloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

     FloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

     FloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
     FloatCharMap newUpdatableMap();

     FloatCharMap newUpdatableMap(int expectedSize);

    


     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
     FloatCharMap newUpdatableMap(Map<Float, Character> map);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

     FloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


     FloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

     FloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

     FloatCharMap newUpdatableMap(float[] keys, char[] values);

     FloatCharMap newUpdatableMap(float[] keys, char[] values,
            int expectedSize);

     FloatCharMap newUpdatableMap(Float[] keys, Character[] values);

     FloatCharMap newUpdatableMap(Float[] keys, Character[] values,
            int expectedSize);

     FloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values);

     FloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


     FloatCharMap newUpdatableMapOf(float k1, char v1);

     FloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2);

     FloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

     FloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

     FloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);

    


     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
     FloatCharMap newImmutableMap(Map<Float, Character> map);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

     FloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


     FloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

     FloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

     FloatCharMap newImmutableMap(float[] keys, char[] values);

     FloatCharMap newImmutableMap(float[] keys, char[] values,
            int expectedSize);

     FloatCharMap newImmutableMap(Float[] keys, Character[] values);

     FloatCharMap newImmutableMap(Float[] keys, Character[] values,
            int expectedSize);

     FloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values);

     FloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


     FloatCharMap newImmutableMapOf(float k1, char v1);

     FloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2);

     FloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

     FloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

     FloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
}

