/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.FloatByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code FloatByteMap}s.
 *
 * @see FloatByteMap
 */
public interface FloatByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see FloatByteMap#defaultValue()
     */
    FloatByteMapFactory withDefaultValue(byte defaultValue);

     FloatByteMap newMutableMap();

     FloatByteMap newMutableMap(int expectedSize);

    


     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
     FloatByteMap newMutableMap(Map<Float, Byte> map);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

     FloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


     FloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

     FloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

     FloatByteMap newMutableMap(float[] keys, byte[] values);

     FloatByteMap newMutableMap(float[] keys, byte[] values,
            int expectedSize);

     FloatByteMap newMutableMap(Float[] keys, Byte[] values);

     FloatByteMap newMutableMap(Float[] keys, Byte[] values,
            int expectedSize);

     FloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values);

     FloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


     FloatByteMap newMutableMapOf(float k1, byte v1);

     FloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2);

     FloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

     FloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

     FloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
     FloatByteMap newUpdatableMap();

     FloatByteMap newUpdatableMap(int expectedSize);

    


     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
     FloatByteMap newUpdatableMap(Map<Float, Byte> map);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

     FloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


     FloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

     FloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

     FloatByteMap newUpdatableMap(float[] keys, byte[] values);

     FloatByteMap newUpdatableMap(float[] keys, byte[] values,
            int expectedSize);

     FloatByteMap newUpdatableMap(Float[] keys, Byte[] values);

     FloatByteMap newUpdatableMap(Float[] keys, Byte[] values,
            int expectedSize);

     FloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values);

     FloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


     FloatByteMap newUpdatableMapOf(float k1, byte v1);

     FloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2);

     FloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

     FloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

     FloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);

    


     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
     FloatByteMap newImmutableMap(Map<Float, Byte> map);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

     FloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


     FloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

     FloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

     FloatByteMap newImmutableMap(float[] keys, byte[] values);

     FloatByteMap newImmutableMap(float[] keys, byte[] values,
            int expectedSize);

     FloatByteMap newImmutableMap(Float[] keys, Byte[] values);

     FloatByteMap newImmutableMap(Float[] keys, Byte[] values,
            int expectedSize);

     FloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values);

     FloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


     FloatByteMap newImmutableMapOf(float k1, byte v1);

     FloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2);

     FloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

     FloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

     FloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
}

