/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleShortMap}s.
 *
 * @see DoubleShortMap
 */
public interface DoubleShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see DoubleShortMap#defaultValue()
     */
    DoubleShortMapFactory withDefaultValue(short defaultValue);

     DoubleShortMap newMutableMap();

     DoubleShortMap newMutableMap(int expectedSize);

    


     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
     DoubleShortMap newMutableMap(Map<Double, Short> map);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

     DoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


     DoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

     DoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

     DoubleShortMap newMutableMap(double[] keys, short[] values);

     DoubleShortMap newMutableMap(double[] keys, short[] values,
            int expectedSize);

     DoubleShortMap newMutableMap(Double[] keys, Short[] values);

     DoubleShortMap newMutableMap(Double[] keys, Short[] values,
            int expectedSize);

     DoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values);

     DoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


     DoubleShortMap newMutableMapOf(double k1, short v1);

     DoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2);

     DoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

     DoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

     DoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
     DoubleShortMap newUpdatableMap();

     DoubleShortMap newUpdatableMap(int expectedSize);

    


     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
     DoubleShortMap newUpdatableMap(Map<Double, Short> map);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

     DoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


     DoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

     DoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

     DoubleShortMap newUpdatableMap(double[] keys, short[] values);

     DoubleShortMap newUpdatableMap(double[] keys, short[] values,
            int expectedSize);

     DoubleShortMap newUpdatableMap(Double[] keys, Short[] values);

     DoubleShortMap newUpdatableMap(Double[] keys, Short[] values,
            int expectedSize);

     DoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values);

     DoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


     DoubleShortMap newUpdatableMapOf(double k1, short v1);

     DoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2);

     DoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

     DoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

     DoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);

    


     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
     DoubleShortMap newImmutableMap(Map<Double, Short> map);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

     DoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


     DoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

     DoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

     DoubleShortMap newImmutableMap(double[] keys, short[] values);

     DoubleShortMap newImmutableMap(double[] keys, short[] values,
            int expectedSize);

     DoubleShortMap newImmutableMap(Double[] keys, Short[] values);

     DoubleShortMap newImmutableMap(Double[] keys, Short[] values,
            int expectedSize);

     DoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values);

     DoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


     DoubleShortMap newImmutableMapOf(double k1, short v1);

     DoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2);

     DoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

     DoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

     DoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
}

