/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleLongMap}s.
 *
 * @see DoubleLongMap
 */
public interface DoubleLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see DoubleLongMap#defaultValue()
     */
    DoubleLongMapFactory withDefaultValue(long defaultValue);

     DoubleLongMap newMutableMap();

     DoubleLongMap newMutableMap(int expectedSize);

    


     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
     DoubleLongMap newMutableMap(Map<Double, Long> map);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

     DoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


     DoubleLongMap newMutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

     DoubleLongMap newMutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

     DoubleLongMap newMutableMap(double[] keys, long[] values);

     DoubleLongMap newMutableMap(double[] keys, long[] values,
            int expectedSize);

     DoubleLongMap newMutableMap(Double[] keys, Long[] values);

     DoubleLongMap newMutableMap(Double[] keys, Long[] values,
            int expectedSize);

     DoubleLongMap newMutableMap(Iterable<Double> keys,
            Iterable<Long> values);

     DoubleLongMap newMutableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


     DoubleLongMap newMutableMapOf(double k1, long v1);

     DoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2);

     DoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

     DoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

     DoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
     DoubleLongMap newUpdatableMap();

     DoubleLongMap newUpdatableMap(int expectedSize);

    


     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
     DoubleLongMap newUpdatableMap(Map<Double, Long> map);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

     DoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


     DoubleLongMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

     DoubleLongMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

     DoubleLongMap newUpdatableMap(double[] keys, long[] values);

     DoubleLongMap newUpdatableMap(double[] keys, long[] values,
            int expectedSize);

     DoubleLongMap newUpdatableMap(Double[] keys, Long[] values);

     DoubleLongMap newUpdatableMap(Double[] keys, Long[] values,
            int expectedSize);

     DoubleLongMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Long> values);

     DoubleLongMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


     DoubleLongMap newUpdatableMapOf(double k1, long v1);

     DoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2);

     DoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

     DoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

     DoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);

    


     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
     DoubleLongMap newImmutableMap(Map<Double, Long> map);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

     DoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


     DoubleLongMap newImmutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

     DoubleLongMap newImmutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

     DoubleLongMap newImmutableMap(double[] keys, long[] values);

     DoubleLongMap newImmutableMap(double[] keys, long[] values,
            int expectedSize);

     DoubleLongMap newImmutableMap(Double[] keys, Long[] values);

     DoubleLongMap newImmutableMap(Double[] keys, Long[] values,
            int expectedSize);

     DoubleLongMap newImmutableMap(Iterable<Double> keys,
            Iterable<Long> values);

     DoubleLongMap newImmutableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


     DoubleLongMap newImmutableMapOf(double k1, long v1);

     DoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2);

     DoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

     DoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

     DoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
}

