/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleIntMap}s.
 *
 * @see DoubleIntMap
 */
public interface DoubleIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see DoubleIntMap#defaultValue()
     */
    DoubleIntMapFactory withDefaultValue(int defaultValue);

     DoubleIntMap newMutableMap();

     DoubleIntMap newMutableMap(int expectedSize);

    


     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
     DoubleIntMap newMutableMap(Map<Double, Integer> map);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

     DoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


     DoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

     DoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

     DoubleIntMap newMutableMap(double[] keys, int[] values);

     DoubleIntMap newMutableMap(double[] keys, int[] values,
            int expectedSize);

     DoubleIntMap newMutableMap(Double[] keys, Integer[] values);

     DoubleIntMap newMutableMap(Double[] keys, Integer[] values,
            int expectedSize);

     DoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values);

     DoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


     DoubleIntMap newMutableMapOf(double k1, int v1);

     DoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2);

     DoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

     DoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

     DoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
     DoubleIntMap newUpdatableMap();

     DoubleIntMap newUpdatableMap(int expectedSize);

    


     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
     DoubleIntMap newUpdatableMap(Map<Double, Integer> map);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

     DoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


     DoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

     DoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

     DoubleIntMap newUpdatableMap(double[] keys, int[] values);

     DoubleIntMap newUpdatableMap(double[] keys, int[] values,
            int expectedSize);

     DoubleIntMap newUpdatableMap(Double[] keys, Integer[] values);

     DoubleIntMap newUpdatableMap(Double[] keys, Integer[] values,
            int expectedSize);

     DoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values);

     DoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


     DoubleIntMap newUpdatableMapOf(double k1, int v1);

     DoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2);

     DoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

     DoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

     DoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);

    


     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
     DoubleIntMap newImmutableMap(Map<Double, Integer> map);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

     DoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


     DoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

     DoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

     DoubleIntMap newImmutableMap(double[] keys, int[] values);

     DoubleIntMap newImmutableMap(double[] keys, int[] values,
            int expectedSize);

     DoubleIntMap newImmutableMap(Double[] keys, Integer[] values);

     DoubleIntMap newImmutableMap(Double[] keys, Integer[] values,
            int expectedSize);

     DoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values);

     DoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


     DoubleIntMap newImmutableMapOf(double k1, int v1);

     DoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2);

     DoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

     DoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

     DoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
}

