/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleFloatMap}s.
 *
 * @see DoubleFloatMap
 */
public interface DoubleFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see DoubleFloatMap#defaultValue()
     */
    DoubleFloatMapFactory withDefaultValue(float defaultValue);

     DoubleFloatMap newMutableMap();

     DoubleFloatMap newMutableMap(int expectedSize);

    


     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
     DoubleFloatMap newMutableMap(Map<Double, Float> map);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

     DoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


     DoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

     DoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

     DoubleFloatMap newMutableMap(double[] keys, float[] values);

     DoubleFloatMap newMutableMap(double[] keys, float[] values,
            int expectedSize);

     DoubleFloatMap newMutableMap(Double[] keys, Float[] values);

     DoubleFloatMap newMutableMap(Double[] keys, Float[] values,
            int expectedSize);

     DoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values);

     DoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


     DoubleFloatMap newMutableMapOf(double k1, float v1);

     DoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2);

     DoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

     DoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

     DoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
     DoubleFloatMap newUpdatableMap();

     DoubleFloatMap newUpdatableMap(int expectedSize);

    


     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
     DoubleFloatMap newUpdatableMap(Map<Double, Float> map);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

     DoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


     DoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

     DoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

     DoubleFloatMap newUpdatableMap(double[] keys, float[] values);

     DoubleFloatMap newUpdatableMap(double[] keys, float[] values,
            int expectedSize);

     DoubleFloatMap newUpdatableMap(Double[] keys, Float[] values);

     DoubleFloatMap newUpdatableMap(Double[] keys, Float[] values,
            int expectedSize);

     DoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values);

     DoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


     DoubleFloatMap newUpdatableMapOf(double k1, float v1);

     DoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2);

     DoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

     DoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

     DoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);

    


     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
     DoubleFloatMap newImmutableMap(Map<Double, Float> map);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

     DoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


     DoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

     DoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

     DoubleFloatMap newImmutableMap(double[] keys, float[] values);

     DoubleFloatMap newImmutableMap(double[] keys, float[] values,
            int expectedSize);

     DoubleFloatMap newImmutableMap(Double[] keys, Float[] values);

     DoubleFloatMap newImmutableMap(Double[] keys, Float[] values,
            int expectedSize);

     DoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values);

     DoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


     DoubleFloatMap newImmutableMapOf(double k1, float v1);

     DoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2);

     DoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

     DoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

     DoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
}

