/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleDoubleMap}s.
 *
 * @see DoubleDoubleMap
 */
public interface DoubleDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see DoubleDoubleMap#defaultValue()
     */
    DoubleDoubleMapFactory withDefaultValue(double defaultValue);

     DoubleDoubleMap newMutableMap();

     DoubleDoubleMap newMutableMap(int expectedSize);

    


     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
     DoubleDoubleMap newMutableMap(Map<Double, Double> map);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

     DoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


     DoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

     DoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

     DoubleDoubleMap newMutableMap(double[] keys, double[] values);

     DoubleDoubleMap newMutableMap(double[] keys, double[] values,
            int expectedSize);

     DoubleDoubleMap newMutableMap(Double[] keys, Double[] values);

     DoubleDoubleMap newMutableMap(Double[] keys, Double[] values,
            int expectedSize);

     DoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values);

     DoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


     DoubleDoubleMap newMutableMapOf(double k1, double v1);

     DoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2);

     DoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

     DoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

     DoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
     DoubleDoubleMap newUpdatableMap();

     DoubleDoubleMap newUpdatableMap(int expectedSize);

    


     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

     DoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


     DoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

     DoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

     DoubleDoubleMap newUpdatableMap(double[] keys, double[] values);

     DoubleDoubleMap newUpdatableMap(double[] keys, double[] values,
            int expectedSize);

     DoubleDoubleMap newUpdatableMap(Double[] keys, Double[] values);

     DoubleDoubleMap newUpdatableMap(Double[] keys, Double[] values,
            int expectedSize);

     DoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values);

     DoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


     DoubleDoubleMap newUpdatableMapOf(double k1, double v1);

     DoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2);

     DoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

     DoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

     DoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);

    


     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
     DoubleDoubleMap newImmutableMap(Map<Double, Double> map);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

     DoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


     DoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

     DoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

     DoubleDoubleMap newImmutableMap(double[] keys, double[] values);

     DoubleDoubleMap newImmutableMap(double[] keys, double[] values,
            int expectedSize);

     DoubleDoubleMap newImmutableMap(Double[] keys, Double[] values);

     DoubleDoubleMap newImmutableMap(Double[] keys, Double[] values,
            int expectedSize);

     DoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values);

     DoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


     DoubleDoubleMap newImmutableMapOf(double k1, double v1);

     DoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2);

     DoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

     DoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

     DoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
}

