/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleCharMap}s.
 *
 * @see DoubleCharMap
 */
public interface DoubleCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see DoubleCharMap#defaultValue()
     */
    DoubleCharMapFactory withDefaultValue(char defaultValue);

     DoubleCharMap newMutableMap();

     DoubleCharMap newMutableMap(int expectedSize);

    


     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
     DoubleCharMap newMutableMap(Map<Double, Character> map);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

     DoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


     DoubleCharMap newMutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

     DoubleCharMap newMutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

     DoubleCharMap newMutableMap(double[] keys, char[] values);

     DoubleCharMap newMutableMap(double[] keys, char[] values,
            int expectedSize);

     DoubleCharMap newMutableMap(Double[] keys, Character[] values);

     DoubleCharMap newMutableMap(Double[] keys, Character[] values,
            int expectedSize);

     DoubleCharMap newMutableMap(Iterable<Double> keys,
            Iterable<Character> values);

     DoubleCharMap newMutableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


     DoubleCharMap newMutableMapOf(double k1, char v1);

     DoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2);

     DoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

     DoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

     DoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
     DoubleCharMap newUpdatableMap();

     DoubleCharMap newUpdatableMap(int expectedSize);

    


     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
     DoubleCharMap newUpdatableMap(Map<Double, Character> map);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

     DoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


     DoubleCharMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

     DoubleCharMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

     DoubleCharMap newUpdatableMap(double[] keys, char[] values);

     DoubleCharMap newUpdatableMap(double[] keys, char[] values,
            int expectedSize);

     DoubleCharMap newUpdatableMap(Double[] keys, Character[] values);

     DoubleCharMap newUpdatableMap(Double[] keys, Character[] values,
            int expectedSize);

     DoubleCharMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Character> values);

     DoubleCharMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


     DoubleCharMap newUpdatableMapOf(double k1, char v1);

     DoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2);

     DoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

     DoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

     DoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);

    


     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
     DoubleCharMap newImmutableMap(Map<Double, Character> map);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

     DoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


     DoubleCharMap newImmutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

     DoubleCharMap newImmutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

     DoubleCharMap newImmutableMap(double[] keys, char[] values);

     DoubleCharMap newImmutableMap(double[] keys, char[] values,
            int expectedSize);

     DoubleCharMap newImmutableMap(Double[] keys, Character[] values);

     DoubleCharMap newImmutableMap(Double[] keys, Character[] values,
            int expectedSize);

     DoubleCharMap newImmutableMap(Iterable<Double> keys,
            Iterable<Character> values);

     DoubleCharMap newImmutableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


     DoubleCharMap newImmutableMapOf(double k1, char v1);

     DoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2);

     DoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

     DoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

     DoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
}

