/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.DoubleByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code DoubleByteMap}s.
 *
 * @see DoubleByteMap
 */
public interface DoubleByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see DoubleByteMap#defaultValue()
     */
    DoubleByteMapFactory withDefaultValue(byte defaultValue);

     DoubleByteMap newMutableMap();

     DoubleByteMap newMutableMap(int expectedSize);

    


     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
     DoubleByteMap newMutableMap(Map<Double, Byte> map);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

     DoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


     DoubleByteMap newMutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

     DoubleByteMap newMutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

     DoubleByteMap newMutableMap(double[] keys, byte[] values);

     DoubleByteMap newMutableMap(double[] keys, byte[] values,
            int expectedSize);

     DoubleByteMap newMutableMap(Double[] keys, Byte[] values);

     DoubleByteMap newMutableMap(Double[] keys, Byte[] values,
            int expectedSize);

     DoubleByteMap newMutableMap(Iterable<Double> keys,
            Iterable<Byte> values);

     DoubleByteMap newMutableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


     DoubleByteMap newMutableMapOf(double k1, byte v1);

     DoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2);

     DoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

     DoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

     DoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
     DoubleByteMap newUpdatableMap();

     DoubleByteMap newUpdatableMap(int expectedSize);

    


     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
     DoubleByteMap newUpdatableMap(Map<Double, Byte> map);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

     DoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


     DoubleByteMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

     DoubleByteMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

     DoubleByteMap newUpdatableMap(double[] keys, byte[] values);

     DoubleByteMap newUpdatableMap(double[] keys, byte[] values,
            int expectedSize);

     DoubleByteMap newUpdatableMap(Double[] keys, Byte[] values);

     DoubleByteMap newUpdatableMap(Double[] keys, Byte[] values,
            int expectedSize);

     DoubleByteMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Byte> values);

     DoubleByteMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


     DoubleByteMap newUpdatableMapOf(double k1, byte v1);

     DoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2);

     DoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

     DoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

     DoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);

    


     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
     DoubleByteMap newImmutableMap(Map<Double, Byte> map);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

     DoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


     DoubleByteMap newImmutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

     DoubleByteMap newImmutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

     DoubleByteMap newImmutableMap(double[] keys, byte[] values);

     DoubleByteMap newImmutableMap(double[] keys, byte[] values,
            int expectedSize);

     DoubleByteMap newImmutableMap(Double[] keys, Byte[] values);

     DoubleByteMap newImmutableMap(Double[] keys, Byte[] values,
            int expectedSize);

     DoubleByteMap newImmutableMap(Iterable<Double> keys,
            Iterable<Byte> values);

     DoubleByteMap newImmutableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


     DoubleByteMap newImmutableMapOf(double k1, byte v1);

     DoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2);

     DoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

     DoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

     DoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
}

