/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharLongMap}s.
 *
 * @see CharLongMap
 */
public interface CharLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see CharLongMap#defaultValue()
     */
    CharLongMapFactory withDefaultValue(long defaultValue);

     CharLongMap newMutableMap();

     CharLongMap newMutableMap(int expectedSize);

    


     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
     CharLongMap newMutableMap(Map<Character, Long> map);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

     CharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


     CharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

     CharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

     CharLongMap newMutableMap(char[] keys, long[] values);

     CharLongMap newMutableMap(char[] keys, long[] values,
            int expectedSize);

     CharLongMap newMutableMap(Character[] keys, Long[] values);

     CharLongMap newMutableMap(Character[] keys, Long[] values,
            int expectedSize);

     CharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values);

     CharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


     CharLongMap newMutableMapOf(char k1, long v1);

     CharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2);

     CharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

     CharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

     CharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
     CharLongMap newUpdatableMap();

     CharLongMap newUpdatableMap(int expectedSize);

    


     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
     CharLongMap newUpdatableMap(Map<Character, Long> map);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

     CharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


     CharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

     CharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

     CharLongMap newUpdatableMap(char[] keys, long[] values);

     CharLongMap newUpdatableMap(char[] keys, long[] values,
            int expectedSize);

     CharLongMap newUpdatableMap(Character[] keys, Long[] values);

     CharLongMap newUpdatableMap(Character[] keys, Long[] values,
            int expectedSize);

     CharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values);

     CharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


     CharLongMap newUpdatableMapOf(char k1, long v1);

     CharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2);

     CharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

     CharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

     CharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);

    


     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
     CharLongMap newImmutableMap(Map<Character, Long> map);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

     CharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


     CharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

     CharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

     CharLongMap newImmutableMap(char[] keys, long[] values);

     CharLongMap newImmutableMap(char[] keys, long[] values,
            int expectedSize);

     CharLongMap newImmutableMap(Character[] keys, Long[] values);

     CharLongMap newImmutableMap(Character[] keys, Long[] values,
            int expectedSize);

     CharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values);

     CharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


     CharLongMap newImmutableMapOf(char k1, long v1);

     CharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2);

     CharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

     CharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

     CharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
}

