/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharIntMap}s.
 *
 * @see CharIntMap
 */
public interface CharIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see CharIntMap#defaultValue()
     */
    CharIntMapFactory withDefaultValue(int defaultValue);

     CharIntMap newMutableMap();

     CharIntMap newMutableMap(int expectedSize);

    


     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
     CharIntMap newMutableMap(Map<Character, Integer> map);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

     CharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


     CharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

     CharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

     CharIntMap newMutableMap(char[] keys, int[] values);

     CharIntMap newMutableMap(char[] keys, int[] values,
            int expectedSize);

     CharIntMap newMutableMap(Character[] keys, Integer[] values);

     CharIntMap newMutableMap(Character[] keys, Integer[] values,
            int expectedSize);

     CharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values);

     CharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


     CharIntMap newMutableMapOf(char k1, int v1);

     CharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2);

     CharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

     CharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

     CharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
     CharIntMap newUpdatableMap();

     CharIntMap newUpdatableMap(int expectedSize);

    


     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
     CharIntMap newUpdatableMap(Map<Character, Integer> map);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

     CharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


     CharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

     CharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

     CharIntMap newUpdatableMap(char[] keys, int[] values);

     CharIntMap newUpdatableMap(char[] keys, int[] values,
            int expectedSize);

     CharIntMap newUpdatableMap(Character[] keys, Integer[] values);

     CharIntMap newUpdatableMap(Character[] keys, Integer[] values,
            int expectedSize);

     CharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values);

     CharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


     CharIntMap newUpdatableMapOf(char k1, int v1);

     CharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2);

     CharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

     CharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

     CharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);

    


     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
     CharIntMap newImmutableMap(Map<Character, Integer> map);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

     CharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


     CharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

     CharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

     CharIntMap newImmutableMap(char[] keys, int[] values);

     CharIntMap newImmutableMap(char[] keys, int[] values,
            int expectedSize);

     CharIntMap newImmutableMap(Character[] keys, Integer[] values);

     CharIntMap newImmutableMap(Character[] keys, Integer[] values,
            int expectedSize);

     CharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values);

     CharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


     CharIntMap newImmutableMapOf(char k1, int v1);

     CharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2);

     CharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

     CharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

     CharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
}

