/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharFloatMap}s.
 *
 * @see CharFloatMap
 */
public interface CharFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see CharFloatMap#defaultValue()
     */
    CharFloatMapFactory withDefaultValue(float defaultValue);

     CharFloatMap newMutableMap();

     CharFloatMap newMutableMap(int expectedSize);

    


     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
     CharFloatMap newMutableMap(Map<Character, Float> map);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

     CharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


     CharFloatMap newMutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

     CharFloatMap newMutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

     CharFloatMap newMutableMap(char[] keys, float[] values);

     CharFloatMap newMutableMap(char[] keys, float[] values,
            int expectedSize);

     CharFloatMap newMutableMap(Character[] keys, Float[] values);

     CharFloatMap newMutableMap(Character[] keys, Float[] values,
            int expectedSize);

     CharFloatMap newMutableMap(Iterable<Character> keys,
            Iterable<Float> values);

     CharFloatMap newMutableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


     CharFloatMap newMutableMapOf(char k1, float v1);

     CharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2);

     CharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

     CharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

     CharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
     CharFloatMap newUpdatableMap();

     CharFloatMap newUpdatableMap(int expectedSize);

    


     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
     CharFloatMap newUpdatableMap(Map<Character, Float> map);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

     CharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


     CharFloatMap newUpdatableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

     CharFloatMap newUpdatableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

     CharFloatMap newUpdatableMap(char[] keys, float[] values);

     CharFloatMap newUpdatableMap(char[] keys, float[] values,
            int expectedSize);

     CharFloatMap newUpdatableMap(Character[] keys, Float[] values);

     CharFloatMap newUpdatableMap(Character[] keys, Float[] values,
            int expectedSize);

     CharFloatMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Float> values);

     CharFloatMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


     CharFloatMap newUpdatableMapOf(char k1, float v1);

     CharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2);

     CharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

     CharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

     CharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);

    


     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
     CharFloatMap newImmutableMap(Map<Character, Float> map);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

     CharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


     CharFloatMap newImmutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

     CharFloatMap newImmutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

     CharFloatMap newImmutableMap(char[] keys, float[] values);

     CharFloatMap newImmutableMap(char[] keys, float[] values,
            int expectedSize);

     CharFloatMap newImmutableMap(Character[] keys, Float[] values);

     CharFloatMap newImmutableMap(Character[] keys, Float[] values,
            int expectedSize);

     CharFloatMap newImmutableMap(Iterable<Character> keys,
            Iterable<Float> values);

     CharFloatMap newImmutableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


     CharFloatMap newImmutableMapOf(char k1, float v1);

     CharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2);

     CharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

     CharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

     CharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
}

