/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharDoubleMap}s.
 *
 * @see CharDoubleMap
 */
public interface CharDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see CharDoubleMap#defaultValue()
     */
    CharDoubleMapFactory withDefaultValue(double defaultValue);

     CharDoubleMap newMutableMap();

     CharDoubleMap newMutableMap(int expectedSize);

    


     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
     CharDoubleMap newMutableMap(Map<Character, Double> map);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

     CharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


     CharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

     CharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

     CharDoubleMap newMutableMap(char[] keys, double[] values);

     CharDoubleMap newMutableMap(char[] keys, double[] values,
            int expectedSize);

     CharDoubleMap newMutableMap(Character[] keys, Double[] values);

     CharDoubleMap newMutableMap(Character[] keys, Double[] values,
            int expectedSize);

     CharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values);

     CharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


     CharDoubleMap newMutableMapOf(char k1, double v1);

     CharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2);

     CharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

     CharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

     CharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
     CharDoubleMap newUpdatableMap();

     CharDoubleMap newUpdatableMap(int expectedSize);

    


     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
     CharDoubleMap newUpdatableMap(Map<Character, Double> map);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

     CharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


     CharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

     CharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

     CharDoubleMap newUpdatableMap(char[] keys, double[] values);

     CharDoubleMap newUpdatableMap(char[] keys, double[] values,
            int expectedSize);

     CharDoubleMap newUpdatableMap(Character[] keys, Double[] values);

     CharDoubleMap newUpdatableMap(Character[] keys, Double[] values,
            int expectedSize);

     CharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values);

     CharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


     CharDoubleMap newUpdatableMapOf(char k1, double v1);

     CharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2);

     CharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

     CharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

     CharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);

    


     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
     CharDoubleMap newImmutableMap(Map<Character, Double> map);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

     CharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


     CharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

     CharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

     CharDoubleMap newImmutableMap(char[] keys, double[] values);

     CharDoubleMap newImmutableMap(char[] keys, double[] values,
            int expectedSize);

     CharDoubleMap newImmutableMap(Character[] keys, Double[] values);

     CharDoubleMap newImmutableMap(Character[] keys, Double[] values,
            int expectedSize);

     CharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values);

     CharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


     CharDoubleMap newImmutableMapOf(char k1, double v1);

     CharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2);

     CharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

     CharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

     CharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
}

