/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharCharMap}s.
 *
 * @see CharCharMap
 */
public interface CharCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see CharCharMap#defaultValue()
     */
    CharCharMapFactory withDefaultValue(char defaultValue);

     CharCharMap newMutableMap();

     CharCharMap newMutableMap(int expectedSize);

    


     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
     CharCharMap newMutableMap(Map<Character, Character> map);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

     CharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


     CharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

     CharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

     CharCharMap newMutableMap(char[] keys, char[] values);

     CharCharMap newMutableMap(char[] keys, char[] values,
            int expectedSize);

     CharCharMap newMutableMap(Character[] keys, Character[] values);

     CharCharMap newMutableMap(Character[] keys, Character[] values,
            int expectedSize);

     CharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values);

     CharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


     CharCharMap newMutableMapOf(char k1, char v1);

     CharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2);

     CharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

     CharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

     CharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
     CharCharMap newUpdatableMap();

     CharCharMap newUpdatableMap(int expectedSize);

    


     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
     CharCharMap newUpdatableMap(Map<Character, Character> map);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

     CharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


     CharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

     CharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

     CharCharMap newUpdatableMap(char[] keys, char[] values);

     CharCharMap newUpdatableMap(char[] keys, char[] values,
            int expectedSize);

     CharCharMap newUpdatableMap(Character[] keys, Character[] values);

     CharCharMap newUpdatableMap(Character[] keys, Character[] values,
            int expectedSize);

     CharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values);

     CharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


     CharCharMap newUpdatableMapOf(char k1, char v1);

     CharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2);

     CharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

     CharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

     CharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);

    


     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
     CharCharMap newImmutableMap(Map<Character, Character> map);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

     CharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


     CharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

     CharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

     CharCharMap newImmutableMap(char[] keys, char[] values);

     CharCharMap newImmutableMap(char[] keys, char[] values,
            int expectedSize);

     CharCharMap newImmutableMap(Character[] keys, Character[] values);

     CharCharMap newImmutableMap(Character[] keys, Character[] values,
            int expectedSize);

     CharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values);

     CharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


     CharCharMap newImmutableMapOf(char k1, char v1);

     CharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2);

     CharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

     CharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

     CharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
}

