/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.CharByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code CharByteMap}s.
 *
 * @see CharByteMap
 */
public interface CharByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see CharByteMap#defaultValue()
     */
    CharByteMapFactory withDefaultValue(byte defaultValue);

     CharByteMap newMutableMap();

     CharByteMap newMutableMap(int expectedSize);

    


     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
     CharByteMap newMutableMap(Map<Character, Byte> map);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

     CharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


     CharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

     CharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

     CharByteMap newMutableMap(char[] keys, byte[] values);

     CharByteMap newMutableMap(char[] keys, byte[] values,
            int expectedSize);

     CharByteMap newMutableMap(Character[] keys, Byte[] values);

     CharByteMap newMutableMap(Character[] keys, Byte[] values,
            int expectedSize);

     CharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values);

     CharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


     CharByteMap newMutableMapOf(char k1, byte v1);

     CharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2);

     CharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

     CharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

     CharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
     CharByteMap newUpdatableMap();

     CharByteMap newUpdatableMap(int expectedSize);

    


     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
     CharByteMap newUpdatableMap(Map<Character, Byte> map);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

     CharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


     CharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

     CharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

     CharByteMap newUpdatableMap(char[] keys, byte[] values);

     CharByteMap newUpdatableMap(char[] keys, byte[] values,
            int expectedSize);

     CharByteMap newUpdatableMap(Character[] keys, Byte[] values);

     CharByteMap newUpdatableMap(Character[] keys, Byte[] values,
            int expectedSize);

     CharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values);

     CharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


     CharByteMap newUpdatableMapOf(char k1, byte v1);

     CharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2);

     CharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

     CharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

     CharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);

    


     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
     CharByteMap newImmutableMap(Map<Character, Byte> map);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

     CharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


     CharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

     CharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

     CharByteMap newImmutableMap(char[] keys, byte[] values);

     CharByteMap newImmutableMap(char[] keys, byte[] values,
            int expectedSize);

     CharByteMap newImmutableMap(Character[] keys, Byte[] values);

     CharByteMap newImmutableMap(Character[] keys, Byte[] values,
            int expectedSize);

     CharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values);

     CharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


     CharByteMap newImmutableMapOf(char k1, byte v1);

     CharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2);

     CharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

     CharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

     CharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
}

