/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteShortMap}s.
 *
 * @see ByteShortMap
 */
public interface ByteShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see ByteShortMap#defaultValue()
     */
    ByteShortMapFactory withDefaultValue(short defaultValue);

     ByteShortMap newMutableMap();

     ByteShortMap newMutableMap(int expectedSize);

    


     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
     ByteShortMap newMutableMap(Map<Byte, Short> map);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

     ByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


     ByteShortMap newMutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

     ByteShortMap newMutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

     ByteShortMap newMutableMap(byte[] keys, short[] values);

     ByteShortMap newMutableMap(byte[] keys, short[] values,
            int expectedSize);

     ByteShortMap newMutableMap(Byte[] keys, Short[] values);

     ByteShortMap newMutableMap(Byte[] keys, Short[] values,
            int expectedSize);

     ByteShortMap newMutableMap(Iterable<Byte> keys,
            Iterable<Short> values);

     ByteShortMap newMutableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


     ByteShortMap newMutableMapOf(byte k1, short v1);

     ByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2);

     ByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

     ByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

     ByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
     ByteShortMap newUpdatableMap();

     ByteShortMap newUpdatableMap(int expectedSize);

    


     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
     ByteShortMap newUpdatableMap(Map<Byte, Short> map);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

     ByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


     ByteShortMap newUpdatableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

     ByteShortMap newUpdatableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

     ByteShortMap newUpdatableMap(byte[] keys, short[] values);

     ByteShortMap newUpdatableMap(byte[] keys, short[] values,
            int expectedSize);

     ByteShortMap newUpdatableMap(Byte[] keys, Short[] values);

     ByteShortMap newUpdatableMap(Byte[] keys, Short[] values,
            int expectedSize);

     ByteShortMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Short> values);

     ByteShortMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


     ByteShortMap newUpdatableMapOf(byte k1, short v1);

     ByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2);

     ByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

     ByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

     ByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);

    


     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
     ByteShortMap newImmutableMap(Map<Byte, Short> map);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

     ByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


     ByteShortMap newImmutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

     ByteShortMap newImmutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

     ByteShortMap newImmutableMap(byte[] keys, short[] values);

     ByteShortMap newImmutableMap(byte[] keys, short[] values,
            int expectedSize);

     ByteShortMap newImmutableMap(Byte[] keys, Short[] values);

     ByteShortMap newImmutableMap(Byte[] keys, Short[] values,
            int expectedSize);

     ByteShortMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Short> values);

     ByteShortMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


     ByteShortMap newImmutableMapOf(byte k1, short v1);

     ByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2);

     ByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

     ByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

     ByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
}

