/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteObjConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteObjMap}s.
 *
 * @see ByteObjMap
 */
public interface ByteObjMapFactory<V> {

    

    

    

    

    

    
    

    
    



    @Nullable Equivalence<V> getValueEquivalence();

    <VE> ByteObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    <V2 extends V> ByteObjMap<V2> newMutableMap();

    <V2 extends V> ByteObjMap<V2> newMutableMap(int expectedSize);

    


    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    <V2 extends V> ByteObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ByteObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newMutableMap(byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ByteObjMap<V2> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ByteObjMap<V2> newMutableMapOf(byte k1, V2 v1);

    <V2 extends V> ByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    <V2 extends V> ByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    <V2 extends V> ByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    <V2 extends V> ByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);
    <V2 extends V> ByteObjMap<V2> newUpdatableMap();

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(int expectedSize);

    


    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    <V2 extends V> ByteObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ByteObjMap<V2> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1);

    <V2 extends V> ByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    <V2 extends V> ByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    <V2 extends V> ByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    <V2 extends V> ByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);

    


    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    <V2 extends V> ByteObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Byte[] keys, V2[] values);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Byte[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ByteObjMap<V2> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1);

    <V2 extends V> ByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    <V2 extends V> ByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    <V2 extends V> ByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    <V2 extends V> ByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);
}

