/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteLongMap}s.
 *
 * @see ByteLongMap
 */
public interface ByteLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see ByteLongMap#defaultValue()
     */
    ByteLongMapFactory withDefaultValue(long defaultValue);

     ByteLongMap newMutableMap();

     ByteLongMap newMutableMap(int expectedSize);

    


     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
     ByteLongMap newMutableMap(Map<Byte, Long> map);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

     ByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


     ByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

     ByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

     ByteLongMap newMutableMap(byte[] keys, long[] values);

     ByteLongMap newMutableMap(byte[] keys, long[] values,
            int expectedSize);

     ByteLongMap newMutableMap(Byte[] keys, Long[] values);

     ByteLongMap newMutableMap(Byte[] keys, Long[] values,
            int expectedSize);

     ByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values);

     ByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


     ByteLongMap newMutableMapOf(byte k1, long v1);

     ByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2);

     ByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

     ByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

     ByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
     ByteLongMap newUpdatableMap();

     ByteLongMap newUpdatableMap(int expectedSize);

    


     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
     ByteLongMap newUpdatableMap(Map<Byte, Long> map);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

     ByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


     ByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

     ByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

     ByteLongMap newUpdatableMap(byte[] keys, long[] values);

     ByteLongMap newUpdatableMap(byte[] keys, long[] values,
            int expectedSize);

     ByteLongMap newUpdatableMap(Byte[] keys, Long[] values);

     ByteLongMap newUpdatableMap(Byte[] keys, Long[] values,
            int expectedSize);

     ByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values);

     ByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


     ByteLongMap newUpdatableMapOf(byte k1, long v1);

     ByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2);

     ByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

     ByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

     ByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);

    


     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
     ByteLongMap newImmutableMap(Map<Byte, Long> map);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

     ByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


     ByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

     ByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

     ByteLongMap newImmutableMap(byte[] keys, long[] values);

     ByteLongMap newImmutableMap(byte[] keys, long[] values,
            int expectedSize);

     ByteLongMap newImmutableMap(Byte[] keys, Long[] values);

     ByteLongMap newImmutableMap(Byte[] keys, Long[] values,
            int expectedSize);

     ByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values);

     ByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


     ByteLongMap newImmutableMapOf(byte k1, long v1);

     ByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2);

     ByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

     ByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

     ByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
}

