/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteIntMap}s.
 *
 * @see ByteIntMap
 */
public interface ByteIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see ByteIntMap#defaultValue()
     */
    ByteIntMapFactory withDefaultValue(int defaultValue);

     ByteIntMap newMutableMap();

     ByteIntMap newMutableMap(int expectedSize);

    


     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
     ByteIntMap newMutableMap(Map<Byte, Integer> map);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

     ByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


     ByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

     ByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

     ByteIntMap newMutableMap(byte[] keys, int[] values);

     ByteIntMap newMutableMap(byte[] keys, int[] values,
            int expectedSize);

     ByteIntMap newMutableMap(Byte[] keys, Integer[] values);

     ByteIntMap newMutableMap(Byte[] keys, Integer[] values,
            int expectedSize);

     ByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

     ByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


     ByteIntMap newMutableMapOf(byte k1, int v1);

     ByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2);

     ByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

     ByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

     ByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
     ByteIntMap newUpdatableMap();

     ByteIntMap newUpdatableMap(int expectedSize);

    


     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
     ByteIntMap newUpdatableMap(Map<Byte, Integer> map);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

     ByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


     ByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

     ByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

     ByteIntMap newUpdatableMap(byte[] keys, int[] values);

     ByteIntMap newUpdatableMap(byte[] keys, int[] values,
            int expectedSize);

     ByteIntMap newUpdatableMap(Byte[] keys, Integer[] values);

     ByteIntMap newUpdatableMap(Byte[] keys, Integer[] values,
            int expectedSize);

     ByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

     ByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


     ByteIntMap newUpdatableMapOf(byte k1, int v1);

     ByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2);

     ByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

     ByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

     ByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);

    


     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
     ByteIntMap newImmutableMap(Map<Byte, Integer> map);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

     ByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


     ByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

     ByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

     ByteIntMap newImmutableMap(byte[] keys, int[] values);

     ByteIntMap newImmutableMap(byte[] keys, int[] values,
            int expectedSize);

     ByteIntMap newImmutableMap(Byte[] keys, Integer[] values);

     ByteIntMap newImmutableMap(Byte[] keys, Integer[] values,
            int expectedSize);

     ByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

     ByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


     ByteIntMap newImmutableMapOf(byte k1, int v1);

     ByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2);

     ByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

     ByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

     ByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
}

