/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteFloatMap}s.
 *
 * @see ByteFloatMap
 */
public interface ByteFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see ByteFloatMap#defaultValue()
     */
    ByteFloatMapFactory withDefaultValue(float defaultValue);

     ByteFloatMap newMutableMap();

     ByteFloatMap newMutableMap(int expectedSize);

    


     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
     ByteFloatMap newMutableMap(Map<Byte, Float> map);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

     ByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


     ByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

     ByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

     ByteFloatMap newMutableMap(byte[] keys, float[] values);

     ByteFloatMap newMutableMap(byte[] keys, float[] values,
            int expectedSize);

     ByteFloatMap newMutableMap(Byte[] keys, Float[] values);

     ByteFloatMap newMutableMap(Byte[] keys, Float[] values,
            int expectedSize);

     ByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values);

     ByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


     ByteFloatMap newMutableMapOf(byte k1, float v1);

     ByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2);

     ByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

     ByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

     ByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
     ByteFloatMap newUpdatableMap();

     ByteFloatMap newUpdatableMap(int expectedSize);

    


     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
     ByteFloatMap newUpdatableMap(Map<Byte, Float> map);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

     ByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


     ByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

     ByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

     ByteFloatMap newUpdatableMap(byte[] keys, float[] values);

     ByteFloatMap newUpdatableMap(byte[] keys, float[] values,
            int expectedSize);

     ByteFloatMap newUpdatableMap(Byte[] keys, Float[] values);

     ByteFloatMap newUpdatableMap(Byte[] keys, Float[] values,
            int expectedSize);

     ByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values);

     ByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


     ByteFloatMap newUpdatableMapOf(byte k1, float v1);

     ByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2);

     ByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

     ByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

     ByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);

    


     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
     ByteFloatMap newImmutableMap(Map<Byte, Float> map);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

     ByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


     ByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

     ByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

     ByteFloatMap newImmutableMap(byte[] keys, float[] values);

     ByteFloatMap newImmutableMap(byte[] keys, float[] values,
            int expectedSize);

     ByteFloatMap newImmutableMap(Byte[] keys, Float[] values);

     ByteFloatMap newImmutableMap(Byte[] keys, Float[] values,
            int expectedSize);

     ByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values);

     ByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


     ByteFloatMap newImmutableMapOf(byte k1, float v1);

     ByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2);

     ByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

     ByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

     ByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
}

