/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteDoubleMap}s.
 *
 * @see ByteDoubleMap
 */
public interface ByteDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see ByteDoubleMap#defaultValue()
     */
    ByteDoubleMapFactory withDefaultValue(double defaultValue);

     ByteDoubleMap newMutableMap();

     ByteDoubleMap newMutableMap(int expectedSize);

    


     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
     ByteDoubleMap newMutableMap(Map<Byte, Double> map);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

     ByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


     ByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

     ByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

     ByteDoubleMap newMutableMap(byte[] keys, double[] values);

     ByteDoubleMap newMutableMap(byte[] keys, double[] values,
            int expectedSize);

     ByteDoubleMap newMutableMap(Byte[] keys, Double[] values);

     ByteDoubleMap newMutableMap(Byte[] keys, Double[] values,
            int expectedSize);

     ByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values);

     ByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


     ByteDoubleMap newMutableMapOf(byte k1, double v1);

     ByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2);

     ByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

     ByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

     ByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
     ByteDoubleMap newUpdatableMap();

     ByteDoubleMap newUpdatableMap(int expectedSize);

    


     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

     ByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


     ByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

     ByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

     ByteDoubleMap newUpdatableMap(byte[] keys, double[] values);

     ByteDoubleMap newUpdatableMap(byte[] keys, double[] values,
            int expectedSize);

     ByteDoubleMap newUpdatableMap(Byte[] keys, Double[] values);

     ByteDoubleMap newUpdatableMap(Byte[] keys, Double[] values,
            int expectedSize);

     ByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values);

     ByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


     ByteDoubleMap newUpdatableMapOf(byte k1, double v1);

     ByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2);

     ByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

     ByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

     ByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);

    


     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
     ByteDoubleMap newImmutableMap(Map<Byte, Double> map);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

     ByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


     ByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

     ByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

     ByteDoubleMap newImmutableMap(byte[] keys, double[] values);

     ByteDoubleMap newImmutableMap(byte[] keys, double[] values,
            int expectedSize);

     ByteDoubleMap newImmutableMap(Byte[] keys, Double[] values);

     ByteDoubleMap newImmutableMap(Byte[] keys, Double[] values,
            int expectedSize);

     ByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values);

     ByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


     ByteDoubleMap newImmutableMapOf(byte k1, double v1);

     ByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2);

     ByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

     ByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

     ByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
}

