/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteCharMap}s.
 *
 * @see ByteCharMap
 */
public interface ByteCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see ByteCharMap#defaultValue()
     */
    ByteCharMapFactory withDefaultValue(char defaultValue);

     ByteCharMap newMutableMap();

     ByteCharMap newMutableMap(int expectedSize);

    


     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
     ByteCharMap newMutableMap(Map<Byte, Character> map);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

     ByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


     ByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

     ByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

     ByteCharMap newMutableMap(byte[] keys, char[] values);

     ByteCharMap newMutableMap(byte[] keys, char[] values,
            int expectedSize);

     ByteCharMap newMutableMap(Byte[] keys, Character[] values);

     ByteCharMap newMutableMap(Byte[] keys, Character[] values,
            int expectedSize);

     ByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values);

     ByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


     ByteCharMap newMutableMapOf(byte k1, char v1);

     ByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2);

     ByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

     ByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

     ByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
     ByteCharMap newUpdatableMap();

     ByteCharMap newUpdatableMap(int expectedSize);

    


     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
     ByteCharMap newUpdatableMap(Map<Byte, Character> map);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

     ByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


     ByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

     ByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

     ByteCharMap newUpdatableMap(byte[] keys, char[] values);

     ByteCharMap newUpdatableMap(byte[] keys, char[] values,
            int expectedSize);

     ByteCharMap newUpdatableMap(Byte[] keys, Character[] values);

     ByteCharMap newUpdatableMap(Byte[] keys, Character[] values,
            int expectedSize);

     ByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values);

     ByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


     ByteCharMap newUpdatableMapOf(byte k1, char v1);

     ByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2);

     ByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

     ByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

     ByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);

    


     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
     ByteCharMap newImmutableMap(Map<Byte, Character> map);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

     ByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


     ByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

     ByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

     ByteCharMap newImmutableMap(byte[] keys, char[] values);

     ByteCharMap newImmutableMap(byte[] keys, char[] values,
            int expectedSize);

     ByteCharMap newImmutableMap(Byte[] keys, Character[] values);

     ByteCharMap newImmutableMap(Byte[] keys, Character[] values,
            int expectedSize);

     ByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values);

     ByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


     ByteCharMap newImmutableMapOf(byte k1, char v1);

     ByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2);

     ByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

     ByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

     ByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
}

