/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ByteByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ByteByteMap}s.
 *
 * @see ByteByteMap
 */
public interface ByteByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see ByteByteMap#defaultValue()
     */
    ByteByteMapFactory withDefaultValue(byte defaultValue);

     ByteByteMap newMutableMap();

     ByteByteMap newMutableMap(int expectedSize);

    


     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
     ByteByteMap newMutableMap(Map<Byte, Byte> map);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

     ByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


     ByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

     ByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

     ByteByteMap newMutableMap(byte[] keys, byte[] values);

     ByteByteMap newMutableMap(byte[] keys, byte[] values,
            int expectedSize);

     ByteByteMap newMutableMap(Byte[] keys, Byte[] values);

     ByteByteMap newMutableMap(Byte[] keys, Byte[] values,
            int expectedSize);

     ByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

     ByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


     ByteByteMap newMutableMapOf(byte k1, byte v1);

     ByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

     ByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

     ByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

     ByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
     ByteByteMap newUpdatableMap();

     ByteByteMap newUpdatableMap(int expectedSize);

    


     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
     ByteByteMap newUpdatableMap(Map<Byte, Byte> map);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

     ByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


     ByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

     ByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

     ByteByteMap newUpdatableMap(byte[] keys, byte[] values);

     ByteByteMap newUpdatableMap(byte[] keys, byte[] values,
            int expectedSize);

     ByteByteMap newUpdatableMap(Byte[] keys, Byte[] values);

     ByteByteMap newUpdatableMap(Byte[] keys, Byte[] values,
            int expectedSize);

     ByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

     ByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


     ByteByteMap newUpdatableMapOf(byte k1, byte v1);

     ByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2);

     ByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

     ByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

     ByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);

    


     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
     ByteByteMap newImmutableMap(Map<Byte, Byte> map);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

     ByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


     ByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

     ByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

     ByteByteMap newImmutableMap(byte[] keys, byte[] values);

     ByteByteMap newImmutableMap(byte[] keys, byte[] values,
            int expectedSize);

     ByteByteMap newImmutableMap(Byte[] keys, Byte[] values);

     ByteByteMap newImmutableMap(Byte[] keys, Byte[] values,
            int expectedSize);

     ByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

     ByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


     ByteByteMap newImmutableMapOf(byte k1, byte v1);

     ByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

     ByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

     ByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

     ByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
}

