/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.util.function.Function;
import net.openhft.chronicle.websocket.jetty.JettyWebSocketServiceAdapter;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class JettyServiceFactory<R, S>
extends WebSocketServlet
implements WebSocketCreator {
    private final Class<R> responseClass;
    private final Function<R, S> serviceFactory;

    public JettyServiceFactory(Class<R> responseClass, Function<R, S> serviceFactory) {
        this.responseClass = responseClass;
        this.serviceFactory = serviceFactory;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)this);
    }

    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        return new JettyWebSocketServiceAdapter<R, S>(this.responseClass, this.serviceFactory);
    }
}

