package net.openhft.chronicle.websocket.jetty;

import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WireIn;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;

/**
 * Created by peter.lawrey on 06/02/2016.
 */
public class JettyWebSocketClient implements MarshallableOut, Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketClient.class);

    private final WebSocketClient client;
    private final JettyWebSocketAdapter<MarshallableOut> adapter;
    private final boolean recordHistory;

    public JettyWebSocketClient(String uriString, BiConsumer<WireIn, MarshallableOut> parser) throws IOException {
        this(uriString, parser, false);
    }

    public JettyWebSocketClient(String uriString, BiConsumer<WireIn, MarshallableOut> parser, boolean recordHistory) throws IOException {
        this.recordHistory = recordHistory;
        URI uri = URI.create(uriString);

        client = new WebSocketClient();

        try {
            client.start();
            // The socket that receives events
            adapter = new JettyWebSocketAdapter<>(out -> out, parser);
            // Attempt Connect
            Future<Session> fut = client.connect(adapter, uri);
            // Wait for Connect
            Session session = fut.get();
            adapter.onWebSocketConnect(session);
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public DocumentContext writingDocument() {
        return adapter.writingDocument();
    }

    @Override
    public boolean recordHistory() {
        return recordHistory;
    }

    @Override
    public void close() {
        try {
            client.stop();
        } catch (Exception e) {
            LOGGER.info("Error on close of " + client, e);
        }
    }
}
