/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BootstrapUtils {
    private static final String CHRONICLE_ENTERPRISE = "software.chronicle";
    private static final String CHRONICLE_CORE = "net.openhft.chronicle.core";
    private static final Set<String> PROTECTED_PACKAGES = new HashSet<String>(){
        {
            this.add(".internal.");
            this.add(".impl.");
        }
    };
    private final Set<String> excluded;

    public BootstrapUtils() {
        this.excluded = Collections.emptySet();
    }

    public BootstrapUtils(Set<String> excluded) {
        this.excluded = excluded;
    }

    protected Set<String> getExcluded() {
        return this.excluded;
    }

    public static void main(String ... args) throws IOException {
        new BootstrapUtils().scanClasses();
    }

    public Set<String> scanClasses() {
        Set allClasses = new ClassFileImporter().withImportOption((ImportOption)new ImportOption.DoNotIncludeTests()).importPackages(new String[]{CHRONICLE_ENTERPRISE, CHRONICLE_CORE}).stream().filter(cls -> cls.getModifiers().contains(JavaModifier.PUBLIC)).collect(Collectors.toSet());
        Set coreClasses = allClasses.stream().filter(cls -> cls.getName().contains(CHRONICLE_CORE)).collect(Collectors.toSet());
        Set protectedClasses = allClasses.stream().filter(cls -> cls.getName().contains(CHRONICLE_ENTERPRISE)).filter(BootstrapUtils::isProtected).collect(Collectors.toSet());
        Set coreNames = coreClasses.stream().map(JavaClass::getName).collect(Collectors.toSet());
        HashSet visited = new HashSet();
        Set candidates = protectedClasses.stream().flatMap(cls -> BootstrapUtils.allReferrers(cls, visited).stream()).filter(BootstrapUtils::notProtected).filter(cls -> cls.getDirectDependenciesFromSelf().stream().map(Dependency::getTargetClass).noneMatch(c -> coreNames.contains(c.getName()))).collect(Collectors.toSet());
        Set candidatesNames = candidates.stream().map(JavaClass::getName).collect(Collectors.toCollection(TreeSet::new));
        candidatesNames.removeAll(this.getExcluded());
        if (!candidatesNames.isEmpty()) {
            System.out.printf("\nPOTENTIAL BOOTSTRAP ISSUES FOUND (%s):\n%s", candidatesNames.size(), String.join((CharSequence)"\n", candidatesNames));
        }
        return candidatesNames;
    }

    @NotNull
    private static Set<JavaClass> allReferrers(JavaClass cls, Set<JavaClass> visited) {
        if (visited.contains(cls)) {
            return visited;
        }
        Set referrers = cls.getDirectDependenciesToSelf().stream().map(Dependency::getOriginClass).filter(c -> !c.equals(cls)).filter(BootstrapUtils::notProtected).collect(Collectors.toSet());
        visited.add(cls);
        for (JavaClass c2 : referrers) {
            visited.addAll(BootstrapUtils.allReferrers(c2, visited));
        }
        return visited;
    }

    private static boolean isProtected(JavaClass cls) {
        return PROTECTED_PACKAGES.stream().anyMatch(p -> cls.getName().contains((CharSequence)p));
    }

    private static boolean notProtected(JavaClass c) {
        return PROTECTED_PACKAGES.stream().noneMatch(p -> c.getName().contains((CharSequence)p));
    }
}

