/**
 * Provides the classes and interfaces necessary for API metrics analysis within
 * the Chronicle Test Framework. This package includes functionality for defining
 * metrics, accumulators, and builders, allowing for detailed analysis of code
 * structures, including classes, methods, and fields.
 *
 * <p>This package enables users to create customized metrics or utilize standard
 * metrics, aggregate the results through accumulators, and build and execute
 * analysis through the ApiMetricsBuilder.</p>
 *
 * <p>Example usage might include analyzing code for compliance with specific
 * coding standards, detecting patterns, or generating reports for code quality
 * assurance.</p>
 *
 * @see net.openhft.chronicle.testframework.apimetrics.ApiMetrics
 * @see net.openhft.chronicle.testframework.apimetrics.Accumulator
 * @see net.openhft.chronicle.testframework.apimetrics.Metric
 */
package net.openhft.chronicle.testframework.apimetrics;
