/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalJavaProcessBuilder
implements JavaProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalJavaProcessBuilder.class);
    private static final String[] NO_ARGUMENTS = new String[0];
    private final Class<?> mainClass;
    private String[] jvmArguments = NO_ARGUMENTS;
    private String[] programArguments = NO_ARGUMENTS;
    private String[] classpathEntries;
    private boolean inheritIO = false;

    public InternalJavaProcessBuilder(@NotNull Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    private static Path findJavaBinPath() {
        Path javaBinPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin");
        Path linuxJavaExecutable = javaBinPath.resolve("java");
        if (linuxJavaExecutable.toFile().exists()) {
            return linuxJavaExecutable;
        }
        Path windowsJavaExecutable = javaBinPath.resolve("java.exe");
        if (windowsJavaExecutable.toFile().exists()) {
            return windowsJavaExecutable;
        }
        throw new IllegalStateException("Couldn't locate java executable!");
    }

    public static void printProcessOutput(String processName, Process process) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("%n Output for %s%n stdout:%n%s stderr:%n%s", processName, InternalJavaProcessBuilder.getProcessStdOut(process), InternalJavaProcessBuilder.getProcessStdErr(process)));
        }
    }

    public static String getProcessStdErr(Process process) {
        return InternalJavaProcessBuilder.copyStreamToString(process.getErrorStream());
    }

    public static String getProcessStdOut(Process process) {
        return InternalJavaProcessBuilder.copyStreamToString(process.getErrorStream());
    }

    private static String copyStreamToString(InputStream inputStream) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int read;
            while (inputStream.available() > 0 && (read = inputStream.read(buffer)) >= 0) {
                os.write(buffer, 0, read);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return os.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public InternalJavaProcessBuilder withProgramArguments(String ... programArguments) {
        this.programArguments = programArguments;
        return this;
    }

    @Override
    public InternalJavaProcessBuilder withJvmArguments(String ... jvmArguments) {
        this.jvmArguments = jvmArguments;
        return this;
    }

    @Override
    public InternalJavaProcessBuilder withClasspathEntries(String ... classpathEntries) {
        this.classpathEntries = classpathEntries;
        return this;
    }

    @Override
    public InternalJavaProcessBuilder inheritingIO() {
        this.inheritIO = true;
        return this;
    }

    @Override
    public Process start() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List jvmArgsWithoutJavaAgents = runtimeMxBean.getInputArguments().stream().filter(arg -> !arg.startsWith("-javaagent:")).filter(arg -> !arg.startsWith("-agentlib:")).collect(Collectors.toList());
        String classPath = this.classpathEntries == null || this.classpathEntries.length == 0 ? System.getProperty("java.class.path") : String.join((CharSequence)System.getProperty("path.separator"), this.classpathEntries);
        String className = this.mainClass.getName();
        String javaBin = InternalJavaProcessBuilder.findJavaBinPath().toString();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(javaBin);
        allArgs.addAll(jvmArgsWithoutJavaAgents);
        allArgs.add("-Dchronicle.analytics.disable=true");
        allArgs.addAll(Arrays.asList(this.jvmArguments));
        allArgs.add("-cp");
        allArgs.add(classPath);
        allArgs.add(className);
        allArgs.addAll(Arrays.asList(this.programArguments));
        ProcessBuilder processBuilder = new ProcessBuilder(allArgs.toArray(new String[0]));
        if (this.inheritIO) {
            LOGGER.warn("You've specified to inherit IO when spawning a Java process, this won't play nice with Maven surefire plugin, don't commit this, see https://maven.apache.org/surefire/maven-failsafe-plugin/faq.html#corruptedstream");
            processBuilder.inheritIO();
        }
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

