/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.openhft.chronicle.testframework.internal.PermutationUtil;
import org.jetbrains.annotations.NotNull;

public final class Permutation {
    private Permutation() {
    }

    public static long factorial(int n) {
        return PermutationUtil.factorial(n);
    }

    public static <T> List<T> permutation(long no, @NotNull List<T> items) {
        if (no < 0L) {
            throw new IllegalArgumentException("no is negative: " + no);
        }
        Objects.requireNonNull(items, "items must not be null");
        return PermutationUtil.permutation(no, items);
    }

    @SafeVarargs
    public static <T> Stream<List<T>> of(T ... items) {
        Objects.requireNonNull(items);
        return PermutationUtil.of(items);
    }

    public static <T> Stream<List<T>> of(@NotNull Collection<T> items) {
        Objects.requireNonNull(items, "items must not be null");
        return PermutationUtil.of(items);
    }

    public static <T> Stream<List<T>> of(@NotNull Stream<T> items) {
        return PermutationUtil.of(items);
    }
}

