/**
 * The {@code net.openhft.chronicle.testframework} package provides a collection of utility classes and enums
 * for various common programming tasks, such as handling closeable resources, generating combinations and permutations,
 * building delegator instances, managing executor services, handling flaky tests, interacting with garbage collection,
 * providing network-related functionalities, generating series of numbers, and thread-related functionalities.
 * <p>
 * This package includes:
 * <ul>
 *     <li>{@link net.openhft.chronicle.testframework.CloseableUtil} for handling closeable resources.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Combination} for generating all possible combinations of elements.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Delegation} for building delegator instances.</li>
 *     <li>{@link net.openhft.chronicle.testframework.ExecutorServiceUtil} for managing executor services.</li>
 *     <li>{@link net.openhft.chronicle.testframework.FlakyTestRunner} for handling flaky tests.</li>
 *     <li>{@link net.openhft.chronicle.testframework.GcControls} for interacting with garbage collection.</li>
 *     <li>{@link net.openhft.chronicle.testframework.NetworkUtil} for providing network-related functionalities.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Permutation} for general permutation support.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Product} for representing a product of elements.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Series} for generating series of numbers.</li>
 *     <li>{@link net.openhft.chronicle.testframework.ThreadUtil} for thread-related functionalities.</li>
 *     <li>{@link net.openhft.chronicle.testframework.Waiters} for waiting for specific conditions to be met.</li>
 * </ul>
 */
package net.openhft.chronicle.testframework;
