/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VanillaExceptionTracker<T>
implements net.openhft.chronicle.testframework.exception.ExceptionTracker<T>,
ExceptionTracker<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VanillaExceptionTracker.class);
    private final Map<Predicate<T>, String> ignoredExceptions = new LinkedHashMap<Predicate<T>, String>();
    private final Map<Predicate<T>, String> expectedExceptions = new LinkedHashMap<Predicate<T>, String>();
    private final Function<T, String> messageExtractor;
    private final Function<T, Throwable> throwableExtractor;
    private final Runnable resetRunnable;
    private final Map<T, Integer> exceptions;
    private final Predicate<T> ignorePredicate;
    private final Function<T, String> exceptionRenderer;
    private boolean finalised = false;

    public VanillaExceptionTracker(@NotNull Function<T, String> messageExtractor, @NotNull Function<T, Throwable> throwableExtractor, @NotNull Runnable resetRunnable, @NotNull Map<T, Integer> exceptions, @NotNull Predicate<T> ignorePredicate) {
        this(messageExtractor, throwableExtractor, resetRunnable, exceptions, ignorePredicate, String::valueOf);
    }

    public VanillaExceptionTracker(@NotNull Function<T, String> messageExtractor, @NotNull Function<T, Throwable> throwableExtractor, @NotNull Runnable resetRunnable, @NotNull Map<T, Integer> exceptions, @NotNull Predicate<T> ignorePredicate, @NotNull Function<T, String> exceptionRenderer) {
        this.messageExtractor = messageExtractor;
        this.throwableExtractor = throwableExtractor;
        this.resetRunnable = resetRunnable;
        this.exceptions = exceptions;
        this.ignorePredicate = ignorePredicate;
        this.exceptionRenderer = exceptionRenderer;
    }

    private static boolean contains(String text, String message) {
        return text != null && text.contains(message);
    }

    private static boolean throwableContainsTextRecursive(@NotNull String text, Throwable throwable) {
        return VanillaExceptionTracker.throwableContainsTextRecursive(text, throwable, new HashSet<Integer>());
    }

    private static boolean throwableContainsTextRecursive(@NotNull String text, Throwable throwable, Set<Integer> seenThrowableIDs) {
        if (throwable == null || seenThrowableIDs.contains(System.identityHashCode(throwable))) {
            return false;
        }
        if (throwable.getMessage() != null && throwable.getMessage().contains(text)) {
            return true;
        }
        seenThrowableIDs.add(System.identityHashCode(throwable));
        return VanillaExceptionTracker.throwableContainsTextRecursive(text, throwable.getCause(), seenThrowableIDs);
    }

    @Override
    public void expectException(@NotNull String message) {
        this.expectException(k -> VanillaExceptionTracker.contains(this.messageExtractor.apply(k), message) || VanillaExceptionTracker.throwableContainsTextRecursive(message, this.throwableExtractor.apply(k)), message);
    }

    @Override
    public void expectException(Predicate<T> predicate, String description) {
        this.checkFinalised();
        this.expectedExceptions.put(predicate, description);
    }

    @Override
    public void ignoreException(@NotNull String message) {
        this.ignoreException(k -> VanillaExceptionTracker.contains(this.messageExtractor.apply(k), message) || VanillaExceptionTracker.throwableContainsTextRecursive(message, this.throwableExtractor.apply(k)), message);
    }

    @Override
    public void ignoreException(Predicate<T> predicate, String description) {
        this.checkFinalised();
        this.ignoredExceptions.put(predicate, description);
    }

    @Override
    public boolean hasException(Predicate<T> predicate) {
        return this.exceptions.keySet().stream().anyMatch(predicate);
    }

    @Override
    public void checkExceptions() {
        this.checkFinalised();
        this.finalised = true;
        for (Map.Entry<Predicate<T>, String> expectedException : this.expectedExceptions.entrySet()) {
            if (!this.exceptions.keySet().removeIf(expectedException.getKey())) {
                throw new AssertionError((Object)("No error for " + expectedException.getValue()));
            }
        }
        for (Map.Entry<Predicate<T>, String> ignoredException : this.ignoredExceptions.entrySet()) {
            if (!this.exceptions.keySet().removeIf(ignoredException.getKey())) continue;
            LOGGER.debug("Ignored {}", (Object)ignoredException.getValue());
        }
        if (this.hasExceptions()) {
            this.dumpException();
            String msg = this.exceptions.size() + " exceptions were detected: " + this.exceptions.keySet().stream().map(this.messageExtractor::apply).collect(Collectors.joining(", "));
            throw new AssertionError((Object)msg);
        }
        this.resetRunnable.run();
    }

    private boolean hasExceptions() {
        for (T k : this.exceptions.keySet()) {
            if (this.ignorePredicate.test(k)) continue;
            return true;
        }
        return false;
    }

    private void dumpException() {
        for (Map.Entry<T, Integer> entry : this.exceptions.entrySet()) {
            T key = entry.getKey();
            LOGGER.warn(this.exceptionRenderer.apply(key), this.throwableExtractor.apply(key));
            Integer value = entry.getValue();
            if (value <= 1) continue;
            LOGGER.warn("Repeated {} times", (Object)value);
        }
    }

    private void checkFinalised() {
        if (this.finalised) {
            throw new IllegalStateException("VanillaExceptionTracker is single use, you create it, add expectations/ignores, run tests, call check and then dispose of it.");
        }
    }
}

