/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public enum ExecutorServiceUtil {

    private static final int DEFAULT_TIME_TO_WAIT_SECONDS = 5;

    public static void shutdownAndWaitForTermination(ExecutorService executorService, long timeout, TimeUnit unit) {
        executorService.shutdown();
        ExecutorServiceUtil.waitForTermination(executorService, timeout, unit);
    }

    public static void shutdownAndWaitForTermination(ExecutorService executorService) {
        executorService.shutdown();
        ExecutorServiceUtil.waitForTermination(executorService, 5L, TimeUnit.SECONDS);
    }

    public static void shutdownForciblyAndWaitForTermination(ExecutorService executorService) {
        ExecutorServiceUtil.shutdownForciblyAndWaitForTermination(executorService, 5L, TimeUnit.SECONDS);
    }

    public static void shutdownForciblyAndWaitForTermination(ExecutorService executorService, long timeout, TimeUnit unit) {
        executorService.shutdownNow();
        ExecutorServiceUtil.waitForTermination(executorService, timeout, unit);
    }

    private static void waitForTermination(ExecutorService executorService, long timeToWait, TimeUnit units) {
        try {
            if (!executorService.awaitTermination(timeToWait, units)) {
                throw new IllegalStateException("ExecutorService didn't shut down");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted waiting for executor service to shut down");
        }
    }
}

