/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.openhft.chronicle.testframework.Combination;
import net.openhft.chronicle.testframework.dto.DtoTester;
import net.openhft.chronicle.testframework.internal.dto.DtoTesterBuilder;
import org.jetbrains.annotations.NotNull;

final class StandardDtoTester<T>
implements DtoTester {
    private static final int MAX_COMBINATION_INPUT = 14;
    private final DtoTesterBuilder<T> builder;

    StandardDtoTester(@NotNull DtoTesterBuilder<T> builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    @Override
    public void test() {
        this.assertInstanceCanBeCreated();
        this.assertConstructorNonReuse();
        this.assertEqualsWorksOnFresh();
        this.assertResettable();
        this.checkHashCode();
        this.assertValidationRules();
    }

    private void assertInstanceCanBeCreated() {
        if (this.createInstance() == null) {
            throw new AssertionError((Object)"Instance was null");
        }
    }

    private void assertConstructorNonReuse() {
        if (this.createInstance() == this.createInstance()) {
            throw new AssertionError((Object)"The constructor must produce new fresh instances");
        }
    }

    private void assertEqualsWorksOnFresh() {
        if (!this.createInstance().equals(this.createInstance())) {
            throw new AssertionError((Object)"Two distinct fresh instances do not equals() each other");
        }
    }

    private void assertResettable() {
        if (this.builder.resetter() == null) {
            return;
        }
        T fresh = this.createInstance();
        List<String> failed = this.newList();
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : this.builder.allMutators()) {
            T t = this.createInstance();
            namedMutator.mutator().accept(t);
            this.builder.resetter().accept(t);
            if (fresh.equals(t)) continue;
            failed.add(namedMutator.name());
        }
        if (!failed.isEmpty()) {
            throw new AssertionError((Object)("Resettable: The mutators " + failed + " were applied but the resetter did not reset these mutations"));
        }
    }

    private void checkHashCode() {
        T fresh = this.createInstance();
        List<String> failed = this.newList();
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : this.builder.allMutators()) {
            T t = this.createInstance();
            namedMutator.mutator().accept(t);
            if (fresh.hashCode() != t.hashCode()) continue;
            failed.add(namedMutator.name());
        }
        failed.forEach(n -> System.err.println("WARNING: hashCode() for the mutator " + n + " was not changed"));
    }

    private void assertValidationRules() {
        if (this.builder.validator() == null) {
            return;
        }
        if (!this.builder.mandatoryMutators().isEmpty()) {
            List<DtoTesterBuilder.NamedMutator<T>> optionalMutators = this.builder.optionalMutators();
            if (optionalMutators.size() > 14) {
                System.out.println("Warning: Fallback to simpler testing because there are so many (" + optionalMutators.size() + ") optional mutators which is more than " + 14);
                optionalMutators.stream().map(Collections::singleton).forEach(this::assertOptionalsDoesNotPass);
            } else {
                Combination.of(optionalMutators).forEach(this::assertOptionalsDoesNotPass);
            }
        }
        List<String> applied = this.newList();
        T t = this.createInstance();
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : this.builder.mandatoryMutators()) {
            try {
                this.builder.validator().accept(t);
                throw new AssertionError((Object)("The mandatory mutators are " + this.builder.mandatoryMutators().stream().map(DtoTesterBuilder.AbstractNamedHolderRecord::name).collect(Collectors.joining(", ", "[", "]")) + " but the validator passed without throwing an Exception on using only " + applied + " applied on a fresh instance -> " + t));
            }
            catch (Exception exception) {
                namedMutator.mutator().accept(t);
                applied.add(namedMutator.name());
            }
        }
        try {
            this.builder.validator().accept(t);
        }
        catch (Exception e) {
            throw new AssertionError("Validation did not pass despite having applied " + applied + " -> " + t, e);
        }
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : this.builder.optionalMutators()) {
            namedMutator.mutator().accept(t);
            this.builder.validator().accept(t);
        }
    }

    private void assertOptionalsDoesNotPass(@NotNull Set<DtoTesterBuilder.NamedMutator<T>> set) {
        Objects.requireNonNull(set);
        List optionalApplied = this.newList();
        T optionalTarget = this.createInstance();
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : set) {
            namedMutator.mutator().accept(optionalTarget);
            try {
                this.builder.validator().accept(optionalTarget);
                throw new AssertionError((Object)("There are at least one mandatory mutator but the validator passed without throwing an Exception on using only optional mutators " + optionalApplied + " applied on a fresh instance -> " + optionalTarget));
            }
            catch (Exception exception) {
            }
        }
    }

    private Collection<String> check(Consumer<? super T> postMutatorAction, BiFunction<T, T, Boolean> tester) {
        T fresh = this.createInstance();
        List<String> failed = this.newList();
        for (DtoTesterBuilder.NamedMutator<T> namedMutator : this.builder.allMutators()) {
            T t = this.createInstance();
            namedMutator.mutator().accept(t);
            postMutatorAction.accept(t);
            if (!tester.apply(fresh, t).booleanValue()) continue;
            failed.add(namedMutator.name());
        }
        return failed;
    }

    private T createInstance() {
        return this.builder.supplier().get();
    }

    private <E> List<E> newList() {
        return new ArrayList();
    }
}

