/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.openhft.chronicle.testframework.dto.DtoTester;
import net.openhft.chronicle.testframework.internal.dto.StandardDtoTester;
import org.jetbrains.annotations.NotNull;

public final class DtoTesterBuilder<T>
implements DtoTester.Builder<T> {
    @NotNull
    private final Class<T> type;
    @NotNull
    private final Supplier<? extends T> supplier;
    @NotNull
    private final List<NamedMutator<T>> mandatoryMutators;
    @NotNull
    private final List<NamedMutator<T>> optionalMutators;
    @NotNull
    private final List<NamedPredicate<T>> validations;
    private Consumer<? super T> resetter;
    private Consumer<? super T> validator;

    public DtoTesterBuilder(@NotNull Class<T> type, @NotNull Supplier<? extends T> supplier) {
        this.type = Objects.requireNonNull(type);
        this.supplier = Objects.requireNonNull(supplier);
        this.mandatoryMutators = this.newList();
        this.optionalMutators = this.newList();
        this.validations = this.newList();
    }

    @Override
    @NotNull
    public <R> DtoTester.Builder<T> withAccessors(@NotNull Function<? super T, ? extends R> getter, @NotNull BiConsumer<? super T, ? super R> setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return this;
    }

    @Override
    @NotNull
    public DtoTester.Builder<T> withResetter(@NotNull Consumer<? super T> resetter) {
        this.resetter = Objects.requireNonNull(resetter);
        return this;
    }

    @Override
    @NotNull
    public DtoTester.Builder<T> withValidator(@NotNull Consumer<? super T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    @NotNull
    public <R> DtoTester.Builder<T> addMutator(@NotNull DtoTester.MutatorType type, @NotNull String mutatorName, @NotNull Consumer<? super T> mutator) {
        switch (type) {
            case MANDATORY: {
                this.mandatoryMutators.add(new NamedMutator<T>(mutatorName, mutator));
                break;
            }
            case OPTIONAL: {
                this.optionalMutators.add(new NamedMutator<T>(mutatorName, mutator));
                break;
            }
            default: {
                throw new IllegalStateException(type.toString());
            }
        }
        return this;
    }

    @Override
    public DtoTester build() {
        return new StandardDtoTester(this);
    }

    Class<T> type() {
        return this.type;
    }

    Supplier<? extends T> supplier() {
        return this.supplier;
    }

    List<NamedMutator<T>> mandatoryMutators() {
        return Collections.unmodifiableList(this.mandatoryMutators);
    }

    List<NamedMutator<T>> optionalMutators() {
        return Collections.unmodifiableList(this.optionalMutators);
    }

    List<NamedMutator<T>> allMutators() {
        List<NamedMutator<T>> all = this.newList();
        all.addAll(this.mandatoryMutators);
        all.addAll(this.optionalMutators);
        return Collections.unmodifiableList(all);
    }

    List<NamedPredicate<T>> validations() {
        return Collections.unmodifiableList(this.validations);
    }

    Consumer<? super T> resetter() {
        return this.resetter;
    }

    Consumer<? super T> validator() {
        return this.validator;
    }

    private <E> List<E> newList() {
        return new ArrayList();
    }

    static abstract class AbstractNamedHolderRecord<H> {
        @NotNull
        private final String name;
        @NotNull
        private final H holder;

        public AbstractNamedHolderRecord(@NotNull String name, @NotNull H holder) {
            this.name = Objects.requireNonNull(name);
            this.holder = Objects.requireNonNull(holder);
        }

        String name() {
            return this.name;
        }

        protected H holder() {
            return this.holder;
        }

        public String toString() {
            return "{name='" + this.name + '\'' + ", holder=" + this.holder + '}';
        }
    }

    static final class NamedPredicate<T>
    extends AbstractNamedHolderRecord<Predicate<? super T>> {
        public NamedPredicate(@NotNull String name, @NotNull Predicate<? super T> predicate) {
            super(name, predicate);
        }

        Predicate<? super T> predicate() {
            return (Predicate)this.holder();
        }
    }

    static final class NamedMutator<T>
    extends AbstractNamedHolderRecord<Consumer<? super T>> {
        public NamedMutator(@NotNull String name, @NotNull Consumer<? super T> mutator) {
            super(name, mutator);
        }

        Consumer<? super T> mutator() {
            return (Consumer)this.holder();
        }
    }
}

