/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalProcessRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalProcessRunner.class);

    private InternalProcessRunner() {
    }

    public static Process runClass(Class<?> clazz, String ... args) throws IOException {
        return InternalProcessRunner.runClass(clazz, new String[0], args, null);
    }

    public static Process runClass(Class<?> clazz, String[] jvmArgs, String[] programArgs, String[] classPathEntries) throws IOException {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List jvmArgsWithoutJavaAgents = runtimeMxBean.getInputArguments().stream().filter(arg -> !arg.startsWith("-javaagent:")).filter(arg -> !arg.startsWith("-agentlib:")).collect(Collectors.toList());
        String classPath = classPathEntries == null || classPathEntries.length == 0 ? System.getProperty("java.class.path") : String.join((CharSequence)":", classPathEntries);
        String className = clazz.getName();
        String javaBin = InternalProcessRunner.findJavaBinPath().toString();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(javaBin);
        allArgs.addAll(jvmArgsWithoutJavaAgents);
        allArgs.addAll(Arrays.asList(jvmArgs));
        allArgs.add("-cp");
        allArgs.add(classPath);
        allArgs.add(className);
        allArgs.addAll(Arrays.asList(programArgs));
        ProcessBuilder processBuilder = new ProcessBuilder(allArgs.toArray(new String[0]));
        return processBuilder.start();
    }

    public static void printProcessOutput(String processName, Process process) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("%n Output for %s%n stdout:%n%s stderr:%n%s", processName, InternalProcessRunner.copyStreamToString(process.getInputStream()), InternalProcessRunner.copyStreamToString(process.getErrorStream())));
        }
    }

    private static String copyStreamToString(InputStream inputStream) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int read;
            while (inputStream.available() > 0 && (read = inputStream.read(buffer)) >= 0) {
                os.write(buffer, 0, read);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(os.toByteArray(), Charset.defaultCharset());
    }

    private static Path findJavaBinPath() {
        Path javaBinPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin");
        Path linuxJavaExecutable = javaBinPath.resolve("java");
        if (linuxJavaExecutable.toFile().exists()) {
            return linuxJavaExecutable;
        }
        Path windowsJavaExecutable = javaBinPath.resolve("java.exe");
        if (windowsJavaExecutable.toFile().exists()) {
            return windowsJavaExecutable;
        }
        throw new IllegalStateException("Couldn't locate java executable!");
    }
}

